/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store.xloader;

import java.util.Iterator;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.system.progress.ProgressMonitorOutput;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.setup.Build;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.tupletable.TupleIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcIndexCopy {
    private static Logger log = LoggerFactory.getLogger(ProcIndexCopy.class);
    static long tickQuantum = 100000L;
    static int superTick = 10;

    public static void exec(String locationStr1, String indexName1, String locationStr2, String indexName2) {
        Location location1 = Location.create(locationStr1);
        Location location2 = Location.create(locationStr2);
        int keyLength = 8 * indexName1.length();
        int valueLength = 0;
        String primary = "SPO";
        String indexOrder = indexName2;
        String label = indexName1 + " => " + indexName2;
        TupleIndex index1 = Build.openTupleIndex(location1, indexName1, primary, indexName1, 10, 10, keyLength, valueLength);
        TupleIndex index2 = Build.openTupleIndex(location2, indexName2, primary, indexOrder, 10, 10, keyLength, valueLength);
        ProcIndexCopy.tupleIndexCopy(index1, index2, label);
        index1.close();
        index2.close();
    }

    private static void tupleIndexCopy(TupleIndex index1, TupleIndex index2, String label) {
        ProgressMonitorOutput monitor = ProgressMonitorOutput.create(log, label, tickQuantum, superTick);
        Timer timer = new Timer();
        timer.startTimer();
        monitor.start();
        Iterator<Tuple<NodeId>> iter1 = index1.all();
        long counter = 0L;
        while (iter1.hasNext()) {
            ++counter;
            Tuple<NodeId> tuple = iter1.next();
            index2.add(tuple);
            monitor.tick();
        }
        index2.sync();
        monitor.finish();
        long time = timer.endTimer();
        float elapsedSecs = (float)time / 1000.0f;
        float rate = elapsedSecs != 0.0f ? (float)counter / elapsedSecs : 0.0f;
        ProcIndexCopy.print("Total: %,d records : %,.2f seconds : %,.2f records/sec [%s]", counter, Float.valueOf(elapsedSecs), Float.valueOf(rate), DateTimeUtils.nowAsString());
    }

    private static void print(String fmt, Object ... args) {
        if (log != null && log.isInfoEnabled()) {
            String str2 = String.format(fmt, args);
            log.info(str2);
        }
    }
}

