/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.CacheSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    private static CacheSet<Object> warningsDone = CacheFactory.createCacheSet(100);

    private Log() {
    }

    public static void info(Object object, String msg) {
        Log.log(object).info(msg);
    }

    public static void info(Object object, String msg, Throwable th) {
        Log.log(object).info(msg, th);
    }

    public static void debug(Object object, String msg) {
        Log.log(object).debug(msg);
    }

    public static void debug(Object object, String msg, Throwable th) {
        Log.log(object).debug(msg, th);
    }

    public static void warn(Object object, String msg) {
        Log.log(object).warn(msg);
    }

    public static void warn(Object object, String msg, Throwable th) {
        Log.log(object).warn(msg, th);
    }

    public static void error(Object object, String msg) {
        Log.log(object).error(msg);
    }

    public static void error(Object object, String msg, Throwable th) {
        Log.log(object).error(msg, th);
    }

    private static Logger log(Object object) {
        if (object instanceof String) {
            String str2 = (String)object;
            return LoggerFactory.getLogger(str2);
        }
        if (object instanceof Logger) {
            Logger logger = (Logger)object;
            return logger;
        }
        if (object instanceof Class) {
            Class cls = (Class)object;
            return LoggerFactory.getLogger(cls);
        }
        return LoggerFactory.getLogger(object.getClass());
    }

    public static void warnOnce(Class<?> cls, String message, Object key) {
        if (!warningsDone.contains(key)) {
            Log.warn(cls, message);
            warningsDone.add(key);
        }
    }

    public static void warnOnce(Logger logger, String message, Object key) {
        if (!warningsDone.contains(key)) {
            logger.warn(message);
            warningsDone.add(key);
        }
    }
}

