/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.qemu.core.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.core.preferences.DefaultPreferences;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.internal.debug.gdbjtag.qemu.core.Activator;
import org.osgi.service.prefs.Preferences;

public class DefaultPreferenceInitializer
extends AbstractPreferenceInitializer {
    DefaultPreferences fDefaultPreferences;
    PersistentPreferences fPersistentPreferences;

    public void initializeDefaultPreferences() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.DefaultPreferenceInitializer.initializeDefaultPreferences()");
        }
        this.fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
        this.fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
        Preferences prefs = Platform.getPreferencesService().getRootNode().node("default");
        if (prefs instanceof IEclipsePreferences) {
            ((IEclipsePreferences)prefs).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)new LateInitializer());
        }
    }

    private class LateInitializer
    implements IEclipsePreferences.INodeChangeListener {
        private LateInitializer() {
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("qemu.LateInitializer.added() " + event + " " + event.getChild().name());
            }
            if ("org.eclipse.embedcdt.debug.gdbjtag.qemu.core".equals(event.getChild().name())) {
                this.finalizeInitializationsDefaultPreferences();
                ((IEclipsePreferences)event.getSource()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("qemu.LateInitializer.removed() " + event);
            }
        }

        public void finalizeInitializationsDefaultPreferences() {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("qemu.LateInitializer.finalizeInitializationsDefaultPreferences()");
            }
            String[] stringArray = PersistentPreferences.architectures;
            int n = PersistentPreferences.architectures.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                this.initializeDefaultsForPrefix(String.valueOf(prefix) + '.');
                ++n2;
            }
            this.initializeDefaultsForPrefix("");
            if (Activator.getInstance().isDebugging()) {
                System.out.println("qemu.LateInitializer.finalizeInitializationsDefaultPreferences() done");
            }
        }

        private void initializeDefaultsForPrefix(String prefix) {
            String path;
            String executableName = DefaultPreferenceInitializer.this.fDefaultPreferences.getExecutableName(prefix);
            if (executableName.isEmpty()) {
                executableName = DefaultPreferenceInitializer.this.fDefaultPreferences.getExecutableNameOs(prefix);
            }
            if (executableName.isEmpty()) {
                executableName = DefaultPreferenceInitializer.this.fPersistentPreferences.getExecutableName(prefix);
            }
            if (!executableName.isEmpty()) {
                DefaultPreferenceInitializer.this.fDefaultPreferences.putExecutableName(prefix, executableName);
            }
            if (!DefaultPreferenceInitializer.this.fDefaultPreferences.checkFolderExecutable(path = DefaultPreferenceInitializer.this.fDefaultPreferences.getInstallFolder(prefix), executableName)) {
                path = DefaultPreferenceInitializer.this.fPersistentPreferences.getInstallFolder(prefix);
            }
            if (!DefaultPreferenceInitializer.this.fDefaultPreferences.checkFolderExecutable(path, executableName)) {
                path = DefaultPreferenceInitializer.this.fDefaultPreferences.discoverInstallPath(prefix, "bin", executableName);
            }
            if (path != null && !path.isEmpty()) {
                DefaultPreferenceInitializer.this.fDefaultPreferences.putInstallFolder(prefix, path);
            }
        }
    }
}

