/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.m2e;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class OSGiConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    public void configureClasspath(IMavenProjectFacade mavenFacade, IClasspathDescriptor desc, IProgressMonitor m) throws CoreException {
        for (IClasspathEntryDescriptor c : desc.getEntryDescriptors()) {
            if (c.getEntryKind() == 2) {
                this.projectEntry(c);
                continue;
            }
            if (c.getEntryKind() != 1) continue;
            this.libraryEntry(c);
        }
    }

    private List<IAccessRule> getAccessRules(Manifest m) {
        String packages = m.getMainAttributes().getValue("Export-Package");
        if (packages != null) {
            try {
                ManifestElement[] packEntries = ManifestElement.parseHeader((String)"Export-Package", (String)packages);
                ArrayList<IAccessRule> rv = new ArrayList<IAccessRule>(packEntries.length + 1);
                ManifestElement[] manifestElementArray = packEntries;
                int n = packEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    ManifestElement packEntry = manifestElementArray[n2];
                    rv.add(JavaCore.newAccessRule((IPath)new Path(packEntry.getValue().replace('.', '/') + "/*"), (int)0));
                    ++n2;
                }
                IAccessRule def = JavaCore.newAccessRule((IPath)new Path("**/*"), (int)1);
                rv.add(def);
                return rv;
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        return Collections.emptyList();
    }

    private void libraryEntry(IClasspathEntryDescriptor c) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JarFile f = new JarFile(c.getPath().toFile());){
                List<IAccessRule> accessRules = this.getAccessRules(f.getManifest());
                if (!accessRules.isEmpty()) {
                    for (IAccessRule r : accessRules) {
                        c.addAccessRule(r);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void projectEntry(IClasspathEntryDescriptor c) {
        block14: {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(c.getPath());
            if (res.exists()) {
                IJavaProject jProject = JavaCore.create((IProject)res.getProject());
                try {
                    IResource mFile = ResourcesPlugin.getWorkspace().getRoot().findMember(jProject.getOutputLocation().append((IPath)new Path("META-INF/MANIFEST.MF")));
                    if (!mFile.exists()) break block14;
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (InputStream in = ((IFile)mFile).getContents();){
                        List<IAccessRule> accessRules = this.getAccessRules(new Manifest(in));
                        if (!accessRules.isEmpty()) {
                            for (IAccessRule r : accessRules) {
                                c.addAccessRule(r);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void configureRawClasspath(ProjectConfigurationRequest mavenFacade, IClasspathDescriptor desc, IProgressMonitor m) throws CoreException {
    }

    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        MojoExecution _execution = new MojoExecution(execution.getPlugin(), execution.getGoal(), "bnd-process");
        _execution.setConfiguration(execution.getConfiguration());
        _execution.setMojoDescriptor(execution.getMojoDescriptor());
        _execution.setLifecyclePhase(execution.getLifecyclePhase());
        return new MojoExecutionBuildParticipant(_execution, true);
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
    }
}

