/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.writelistener;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet_http.writelistener.TestListener;
import servlet.tck.api.jakarta_servlet_http.writelistener.TestServlet;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;
import servlet.tck.common.util.ServletTestUtil;

public class WriteListenerTests
extends AbstractTckTest {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"writelistener.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{TestServlet.class, TestListener.class});
    }

    @Test
    public void nioOutputTest() throws Exception {
        boolean passed = true;
        String testName = "nioOutputTest";
        String EXPECTED_RESPONSE = "=onWritePossible";
        String requestUrl = this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName;
        URL url = new URL(this.getURLString("http", this._hostname, this._port, requestUrl.substring(1)));
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            this.logger.debug("======= Connecting {}", (Object)url.toExternalForm());
            conn.setChunkedStreamingMode(5);
            conn.setDoOutput(true);
            this.logger.trace("======= Header {}", (Object)conn);
            conn.connect();
            try (BufferedReader input = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String line = null;
                StringBuilder message_received = new StringBuilder();
                while ((line = input.readLine()) != null) {
                    this.logger.debug("======= message received: " + line);
                    message_received.append(line);
                }
                passed = ServletTestUtil.compareString(EXPECTED_RESPONSE, message_received.toString());
            }
        }
        catch (Exception ex) {
            passed = false;
            this.logger.error("Test" + ex.getMessage(), (Throwable)ex);
        }
        if (!passed) {
            throw new Exception("Test Failed.");
        }
    }
}

