/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.DefaultErrorHandler;
import org.glassfish.wasp.compiler.ErrorHandler;
import org.glassfish.wasp.compiler.JavacErrorDetail;
import org.glassfish.wasp.compiler.Localizer;
import org.glassfish.wasp.compiler.Mark;
import org.glassfish.wasp.compiler.Node;
import org.xml.sax.SAXException;

public class ErrorDispatcher {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.glassfish.wasp.resources.messages");
    private ErrorHandler errHandler = new DefaultErrorHandler();
    private boolean jspcMode = false;

    public ErrorDispatcher(boolean jspcMode) {
        this.jspcMode = jspcMode;
    }

    public void jspError(String errCode) throws WaspException {
        this.dispatch(null, errCode, null, null);
    }

    public void jspError(Mark where, String errCode) throws WaspException {
        this.dispatch(where, errCode, null, null);
    }

    public void jspError(Mark where, Exception e) throws WaspException {
        this.dispatch(where, e.getMessage(), null, e);
    }

    public void jspError(Node n, String errCode) throws WaspException {
        this.dispatch(n.getStart(), errCode, null, null);
    }

    public void jspError(String errCode, String ... args) throws WaspException {
        this.dispatch(null, errCode, args, null);
    }

    public void jspError(Mark where, String errCode, String ... args) throws WaspException {
        this.dispatch(where, errCode, args, null);
    }

    public void jspError(Node n, String errCode, String ... args) throws WaspException {
        this.dispatch(n.getStart(), errCode, args, null);
    }

    public void jspError(Exception e) throws WaspException {
        this.dispatch(null, null, null, e);
    }

    public void jspError(String errCode, String arg, Exception e) throws WaspException {
        this.dispatch(null, errCode, new Object[]{arg}, e);
    }

    public void jspError(Node n, String errCode, String arg, Exception e) throws WaspException {
        this.dispatch(n.getStart(), errCode, new Object[]{arg}, e);
    }

    public void throwException(Mark where, WaspException je) throws WaspException {
        if (where == null) {
            throw je;
        }
        String file = null;
        if (this.jspcMode) {
            try {
                file = where.getURL().toString();
            }
            catch (MalformedURLException me) {
                file = where.getFile();
            }
        } else {
            file = where.getFile();
        }
        WaspException newEx = new WaspException(file + "(" + where.getLineNumber() + "," + where.getColumnNumber() + ") " + je.getMessage(), je.getCause());
        newEx.setStackTrace(je.getStackTrace());
        throw newEx;
    }

    public void javacError(JavacErrorDetail[] javacErrors) throws WaspException {
        this.errHandler.javacError(javacErrors);
    }

    public void javacError(String errorReport, Exception e) throws WaspException {
        this.errHandler.javacError(errorReport, e);
    }

    private void dispatch(Mark where, String errCode, Object[] args, Exception e) throws WaspException {
        String file = null;
        String errMsg = null;
        int line = -1;
        int column = -1;
        boolean hasLocation = false;
        if (errCode != null) {
            errMsg = Localizer.getMessage(errCode, args);
        } else if (e != null) {
            errMsg = e.getMessage();
        }
        if (where != null) {
            if (this.jspcMode) {
                try {
                    file = where.getURL().toString();
                }
                catch (MalformedURLException me) {
                    file = where.getFile();
                }
            } else {
                file = where.getFile();
            }
            line = where.getLineNumber();
            column = where.getColumnNumber();
            hasLocation = true;
        }
        Exception nestedEx = e;
        if (e instanceof SAXException && ((SAXException)e).getException() != null) {
            nestedEx = ((SAXException)e).getException();
        }
        if (hasLocation) {
            this.errHandler.jspError(file, line, column, errMsg, nestedEx);
        } else {
            this.errHandler.jspError(errMsg, nestedEx);
        }
    }

    public static JavacErrorDetail[] parseJavacMessage(Node.Nodes pageNodes, String errMsg, String fname) throws IOException, WaspException {
        ArrayList<JavacErrorDetail> errors = new ArrayList<JavacErrorDetail>();
        StringBuilder errMsgBuf = null;
        int lineNum = -1;
        JavacErrorDetail javacError = null;
        BufferedReader reader = new BufferedReader(new StringReader(errMsg));
        String line = null;
        while ((line = reader.readLine()) != null) {
            int beginColon = line.indexOf(58, 2);
            int endColon = line.indexOf(58, beginColon + 1);
            if (beginColon >= 0 && endColon >= 0) {
                if (javacError != null) {
                    errors.add(javacError);
                }
                String lineNumStr = line.substring(beginColon + 1, endColon);
                try {
                    lineNum = Integer.parseInt(lineNumStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                errMsgBuf = new StringBuilder();
                javacError = ErrorDispatcher.createJavacError(fname, pageNodes, errMsgBuf, lineNum);
            }
            if (errMsgBuf == null) continue;
            errMsgBuf.append(line);
            errMsgBuf.append("\n");
        }
        if (javacError != null) {
            errors.add(javacError);
        }
        reader.close();
        return errors.toArray(new JavacErrorDetail[0]);
    }

    public static JavacErrorDetail createJavacError(String fname, Node.Nodes page, StringBuilder errMsgBuf, int lineNum) throws WaspException {
        Node errNode;
        ErrorVisitor errVisitor = new ErrorVisitor(lineNum);
        if (page != null) {
            page.visit(errVisitor);
        }
        JavacErrorDetail javacError = (errNode = errVisitor.getJspSourceNode()) != null && errNode.getStart() != null ? new JavacErrorDetail(fname, lineNum, errNode.getStart().getFile(), errNode.getStart().getLineNumber(), errMsgBuf) : new JavacErrorDetail(fname, lineNum, errMsgBuf);
        return javacError;
    }

    static class ErrorVisitor
    extends Node.Visitor {
        private int lineNum;
        Node found;

        public ErrorVisitor(int lineNum) {
            this.lineNum = lineNum;
        }

        @Override
        public void doVisit(Node n) throws WaspException {
            if (this.lineNum >= n.getBeginJavaLine() && this.lineNum < n.getEndJavaLine()) {
                this.found = n;
            }
        }

        public Node getJspSourceNode() {
            return this.found;
        }
    }
}

