/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractUniversalComparableAssert<SELF extends AbstractUniversalComparableAssert<SELF, T>, T>
extends AbstractObjectAssert<SELF, Comparable<T>> {
    @VisibleForTesting
    Comparables comparables = new Comparables();

    protected AbstractUniversalComparableAssert(Comparable<T> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isEqualByComparingTo(T other) {
        this.comparables.assertEqualByComparison(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractUniversalComparableAssert)this.myself);
    }

    public SELF isNotEqualByComparingTo(T other) {
        this.comparables.assertNotEqualByComparison(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractUniversalComparableAssert)this.myself);
    }

    public SELF isLessThan(T other) {
        this.comparables.assertLessThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractUniversalComparableAssert)this.myself);
    }

    public SELF isLessThanOrEqualTo(T other) {
        this.comparables.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractUniversalComparableAssert)this.myself);
    }

    public SELF isGreaterThan(T other) {
        this.comparables.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractUniversalComparableAssert)this.myself);
    }

    public SELF isGreaterThanOrEqualTo(T other) {
        this.comparables.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractUniversalComparableAssert)this.myself);
    }

    public SELF isBetween(T startInclusive, T endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractUniversalComparableAssert)this.myself);
    }

    public SELF isStrictlyBetween(T startExclusive, T endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractUniversalComparableAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Comparable<T>> customComparator) {
        return (SELF)((AbstractUniversalComparableAssert)super.usingComparator(customComparator));
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Comparable<T>> customComparator, String customComparatorDescription) {
        this.comparables = new Comparables(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractUniversalComparableAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.comparables = new Comparables();
        return (SELF)((AbstractUniversalComparableAssert)super.usingDefaultComparator());
    }

    @Override
    @CheckReturnValue
    public SELF inHexadecimal() {
        return (SELF)((AbstractUniversalComparableAssert)super.inHexadecimal());
    }

    @Override
    @CheckReturnValue
    public SELF inBinary() {
        return (SELF)((AbstractUniversalComparableAssert)super.inBinary());
    }
}

