/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Comparator;
import java.util.Objects;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.ByteArrayAssert;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.error.ShouldBeNumeric;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.VisibleForTesting;

public class AbstractStringAssert<SELF extends AbstractStringAssert<SELF>>
extends AbstractCharSequenceAssert<SELF, String> {
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    Comparables comparables = new Comparables();

    protected AbstractStringAssert(String actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isLessThan(String other) {
        this.comparables.assertLessThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isLessThanOrEqualTo(String other) {
        this.comparables.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isGreaterThan(String other) {
        this.comparables.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isGreaterThanOrEqualTo(String other) {
        this.comparables.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isBase64() {
        this.strings.assertIsBase64(this.info, (String)this.actual);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    @CheckReturnValue
    public AbstractByteArrayAssert<?> asBase64Decoded() {
        this.isBase64();
        return (AbstractByteArrayAssert)new ByteArrayAssert(Base64.getDecoder().decode((String)this.actual)).withAssertionState(this.myself);
    }

    @Deprecated
    @CheckReturnValue
    public AbstractByteArrayAssert<?> decodedAsBase64() {
        return this.asBase64Decoded();
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super String> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super String> customComparator, String customComparatorDescription) {
        this.comparables = new Comparables(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractStringAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.comparables = new Comparables();
        return (SELF)((AbstractStringAssert)super.usingDefaultComparator());
    }

    public SELF isEqualTo(String expectedStringTemplate, Object ... args) {
        Objects.requireNonNull(expectedStringTemplate, "The expectedStringTemplate must not be null");
        return (SELF)((AbstractStringAssert)super.isEqualTo(String.format(expectedStringTemplate, args)));
    }

    public SELF isEqualTo(String expected) {
        return (SELF)((AbstractStringAssert)super.isEqualTo(expected));
    }

    public AbstractBooleanAssert<?> asBoolean() {
        return (AbstractBooleanAssert)((AbstractBooleanAssert)InstanceOfAssertFactories.BOOLEAN.createAssert((Object)Boolean.parseBoolean((String)this.actual))).withAssertionState(this.myself);
    }

    public AbstractByteAssert<?> asByte() {
        try {
            return (AbstractByteAssert)((AbstractByteAssert)InstanceOfAssertFactories.BYTE.createAssert((Object)Byte.parseByte((String)this.actual))).withAssertionState(this.myself);
        }
        catch (NumberFormatException e) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldBeNumeric.shouldBeNumeric((String)this.actual, ShouldBeNumeric.NumericType.BYTE));
        }
    }

    public AbstractByteArrayAssert<?> bytes() {
        this.isNotNull();
        return (AbstractByteArrayAssert)((AbstractByteArrayAssert)InstanceOfAssertFactories.BYTE_ARRAY.createAssert((Object)((String)this.actual).getBytes())).withAssertionState(this.myself);
    }

    public AbstractByteArrayAssert<?> bytes(Charset charset) {
        this.isNotNull();
        byte[] bytes = ((String)this.actual).getBytes(Objects.requireNonNull(charset, "The charset must not be null"));
        return (AbstractByteArrayAssert)((AbstractByteArrayAssert)InstanceOfAssertFactories.BYTE_ARRAY.createAssert((Object)bytes)).withAssertionState(this.myself);
    }

    public AbstractByteArrayAssert<?> bytes(String charsetName) {
        this.isNotNull();
        try {
            byte[] bytes = ((String)this.actual).getBytes(Objects.requireNonNull(charsetName, "The charsetName must not be null"));
            return (AbstractByteArrayAssert)((AbstractByteArrayAssert)InstanceOfAssertFactories.BYTE_ARRAY.createAssert((Object)bytes)).withAssertionState(this.myself);
        }
        catch (UnsupportedEncodingException e) {
            throw this.failures.failure(charsetName + " is not a supported Charset");
        }
    }

    public AbstractShortAssert<?> asShort() {
        try {
            return (AbstractShortAssert)((AbstractShortAssert)InstanceOfAssertFactories.SHORT.createAssert((Object)Short.parseShort((String)this.actual))).withAssertionState(this.myself);
        }
        catch (NumberFormatException e) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldBeNumeric.shouldBeNumeric((String)this.actual, ShouldBeNumeric.NumericType.SHORT));
        }
    }

    public AbstractIntegerAssert<?> asInt() {
        try {
            return (AbstractIntegerAssert)((AbstractIntegerAssert)InstanceOfAssertFactories.INTEGER.createAssert((Object)Integer.parseInt((String)this.actual))).withAssertionState(this.myself);
        }
        catch (NumberFormatException e) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldBeNumeric.shouldBeNumeric((String)this.actual, ShouldBeNumeric.NumericType.INTEGER));
        }
    }

    public AbstractLongAssert<?> asLong() {
        try {
            return (AbstractLongAssert)((AbstractLongAssert)InstanceOfAssertFactories.LONG.createAssert((Object)Long.parseLong((String)this.actual))).withAssertionState(this.myself);
        }
        catch (NumberFormatException e) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldBeNumeric.shouldBeNumeric((String)this.actual, ShouldBeNumeric.NumericType.LONG));
        }
    }

    public AbstractFloatAssert<?> asFloat() {
        try {
            return (AbstractFloatAssert)((AbstractFloatAssert)InstanceOfAssertFactories.FLOAT.createAssert((Object)Float.valueOf(Float.parseFloat((String)this.actual)))).withAssertionState(this.myself);
        }
        catch (NullPointerException | NumberFormatException e) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldBeNumeric.shouldBeNumeric((String)this.actual, ShouldBeNumeric.NumericType.FLOAT));
        }
    }

    public AbstractDoubleAssert<?> asDouble() {
        try {
            return (AbstractDoubleAssert)((AbstractDoubleAssert)InstanceOfAssertFactories.DOUBLE.createAssert((Object)Double.parseDouble((String)this.actual))).withAssertionState(this.myself);
        }
        catch (NullPointerException | NumberFormatException e) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldBeNumeric.shouldBeNumeric((String)this.actual, ShouldBeNumeric.NumericType.DOUBLE));
        }
    }
}

