/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.util.Arrays;

public class SegToken {
    public char[] charArray;
    public int startOffset;
    public int endOffset;
    public int wordType;
    public int weight;
    public int index;

    public SegToken(char[] idArray, int start, int end, int wordType, int weight) {
        this.charArray = idArray;
        this.startOffset = start;
        this.endOffset = end;
        this.wordType = wordType;
        this.weight = weight;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (int i = 0; i < this.charArray.length; ++i) {
            result = 31 * result + this.charArray[i];
        }
        result = 31 * result + this.endOffset;
        result = 31 * result + this.index;
        result = 31 * result + this.startOffset;
        result = 31 * result + this.weight;
        result = 31 * result + this.wordType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegToken other = (SegToken)obj;
        if (!Arrays.equals(this.charArray, other.charArray)) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.startOffset != other.startOffset) {
            return false;
        }
        if (this.weight != other.weight) {
            return false;
        }
        return this.wordType == other.wordType;
    }
}

