/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.filter.IPeakFilter;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.processing.Processor;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.CRUDListener;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.xxd.model.filter.peaks.ClassifierFilterSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IPeakFilter.class, Filter.class, Processor.class})
public class ClassifierFilter
implements IPeakFilter<ClassifierFilterSettings> {
    public String getName() {
        return "Peak Classifier";
    }

    public String getDescription() {
        return "Filter peaks and add peak classifier (e.g. for the whole name or parts of the name).";
    }

    public Class<ClassifierFilterSettings> getConfigClass() {
        return ClassifierFilterSettings.class;
    }

    public boolean acceptsIPeaks(Collection<? extends IPeak> items) {
        return true;
    }

    public <X extends IPeak> void filterIPeaks(CRUDListener<X, IPeakModel> listener, ClassifierFilterSettings configuration, MessageConsumer messageConsumer, IProgressMonitor monitor) throws IllegalArgumentException {
        Collection read = listener.read();
        if (configuration == null) {
            configuration = (ClassifierFilterSettings)this.createConfiguration(read);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)read.size());
        LinkedHashMap<String, String> parsedUserDefinedValues = ClassifierFilter.parseUserDefinedValuesAsMap(configuration);
        for (IPeak peak : read) {
            ClassifierFilter.setPeakClassifier(configuration, parsedUserDefinedValues, peak);
            subMonitor.worked(1);
        }
    }

    private static LinkedHashMap<String, String> parseUserDefinedValuesAsMap(ClassifierFilterSettings configuration) {
        String userDefinedMatchExpression = configuration.getUserDefinedMatchExpression();
        ArrayList<String> expressions = new ArrayList<String>();
        if (userDefinedMatchExpression.isEmpty()) {
            throw new IllegalArgumentException("No match expressions defined!");
        }
        expressions.addAll(ClassifierFilter.parseExpressions(userDefinedMatchExpression));
        ArrayList<String> classifications = new ArrayList<String>();
        String matchClassification = configuration.getMatchClassification();
        if (matchClassification.isEmpty()) {
            throw new IllegalArgumentException("No match classifications defined!");
        }
        classifications.addAll(ClassifierFilter.parseExpressions(matchClassification));
        if (expressions.size() != classifications.size()) {
            throw new IllegalArgumentException("The number of Expressions is not the same as the number of Classifications.");
        }
        LinkedHashMap<String, String> parsedUserDefinedValues = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < expressions.size()) {
            parsedUserDefinedValues.put((String)expressions.get(i), (String)classifications.get(i));
            ++i;
        }
        return parsedUserDefinedValues;
    }

    private static List<String> parseExpressions(String userExpressions) {
        ArrayList<String> expressionsList = new ArrayList<String>();
        String[] tempExpressions = userExpressions.split(System.getProperty("line.separator"));
        int i = 0;
        while (i < tempExpressions.length) {
            if (!tempExpressions[i].isEmpty()) {
                expressionsList.add(tempExpressions[i]);
            }
            ++i;
        }
        return expressionsList;
    }

    private static <X extends IPeak> void setPeakClassifier(ClassifierFilterSettings configuration, LinkedHashMap<String, String> parsedUserDefinedValues, X peak) {
        peak.removeClassifier("");
        for (IIdentificationTarget target : peak.getTargets()) {
            String substanceName = ClassifierFilter.extractSubstanceName(configuration, target);
            if (substanceName == null) continue;
            for (Map.Entry<String, String> entry : parsedUserDefinedValues.entrySet()) {
                Pattern pattern = ClassifierFilter.createPattern(configuration, entry);
                Matcher matcher = pattern.matcher(substanceName);
                if (configuration.isWildcardSearch()) {
                    if (!matcher.find()) continue;
                    peak.addClassifier(entry.getValue());
                    continue;
                }
                if (!matcher.matches()) continue;
                peak.addClassifier(entry.getValue());
            }
        }
    }

    private static Pattern createPattern(ClassifierFilterSettings configuration, Map.Entry<String, String> entry) {
        Pattern pattern = null;
        pattern = configuration.isIgnoreUppercase() ? Pattern.compile(entry.getKey(), 2) : Pattern.compile(entry.getKey());
        return pattern;
    }

    private static String extractSubstanceName(ClassifierFilterSettings configuration, IIdentificationTarget identificationTarget) {
        ILibraryInformation libraryInformation;
        if (identificationTarget != null && (libraryInformation = identificationTarget.getLibraryInformation()) != null) {
            if (configuration.isIgnoreUppercase()) {
                return libraryInformation.getName().toLowerCase();
            }
            return libraryInformation.getName();
        }
        return null;
    }
}

