/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.jcampdx.model;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.supplier.jcampdx.model.IVendorScan;
import org.eclipse.chemclipse.msd.converter.supplier.jcampdx.model.VendorIon;
import org.eclipse.chemclipse.msd.model.core.AbstractVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;

public class VendorScan
extends AbstractVendorMassSpectrum
implements IVendorScan {
    private static final long serialVersionUID = -8269450222663957541L;
    private static final Logger logger = Logger.getLogger(VendorScan.class);
    public static final int MAX_IONS = 2000;
    public static final int MIN_RETENTION_TIME = 0;
    public static final int MAX_RETENTION_TIME = Integer.MAX_VALUE;

    public int getMaxPossibleIons() {
        return 2000;
    }

    public int getMaxPossibleRetentionTime() {
        return Integer.MAX_VALUE;
    }

    public int getMinPossibleRetentionTime() {
        return 0;
    }

    public IVendorScan makeDeepCopy() throws CloneNotSupportedException {
        IVendorScan massSpectrum = (IVendorScan)super.clone();
        for (IIon ion : this.getIons()) {
            try {
                VendorIon jcampIon = new VendorIon(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon((IIon)jcampIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

