/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.util.List;
import org.eclipse.chemclipse.pcr.model.core.IPlate;
import org.eclipse.chemclipse.pcr.model.core.IWell;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePCR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PCRPlate;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExtendedPCRPlateUI {
    private Label labelDataInfo;
    private PCRPlate pcrPlate;
    private Combo comboSubsets;
    private Combo comboChannels;
    private IPlate plate;

    public ExtendedPCRPlateUI(Composite parent) {
        this.initialize(parent);
    }

    public void update(IPlate plate) {
        this.plate = plate;
        this.updateWidget();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.createPlateUI(parent);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(5, false));
        this.createDataInfoLabel(composite);
        this.comboSubsets = this.createComboSubsets(composite);
        this.comboChannels = this.createComboChannels(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private void createDataInfoLabel(Composite parent) {
        this.labelDataInfo = new Label(parent, 0);
        this.labelDataInfo.setText("");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.labelDataInfo.setLayoutData((Object)gridData);
    }

    private Combo createComboSubsets(Composite parent) {
        final Combo combo = new Combo(parent, 8);
        combo.setToolTipText("Selection of the subsets");
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String activeSubset = combo.getText();
                if (ExtendedPCRPlateUI.this.plate != null) {
                    ExtendedPCRPlateUI.this.plate.setActiveSubset(activeSubset);
                    ExtendedPCRPlateUI.this.fireUpdate(e.widget.getDisplay(), ExtendedPCRPlateUI.this.pcrPlate.getSelectedWell());
                    ExtendedPCRPlateUI.this.pcrPlate.refresh();
                }
            }
        });
        return combo;
    }

    private Combo createComboChannels(Composite parent) {
        final Combo combo = new Combo(parent, 8);
        combo.setToolTipText("Select a channel specification.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedPCRPlateUI.this.plate != null) {
                    String selection = combo.getText();
                    if ("All Channels".equals(selection)) {
                        ExtendedPCRPlateUI.this.plate.setActiveChannel(-1);
                    } else {
                        ExtendedPCRPlateUI.this.plate.setActiveChannel(combo.getSelectionIndex() - 1);
                    }
                    ExtendedPCRPlateUI.this.fireUpdate(e.widget.getDisplay(), ExtendedPCRPlateUI.this.pcrPlate.getSelectedWell());
                    ExtendedPCRPlateUI.this.pcrPlate.refresh();
                }
            }
        });
        return combo;
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the scan");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPCRPlateUI.this.reset();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePagePCR preferencePage = new PreferencePagePCR();
                preferencePage.setTitle("PCR");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedPCRPlateUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void applySettings() {
        this.reset();
    }

    private void reset() {
        this.updateWidget();
    }

    private void createPlateUI(Composite parent) {
        this.pcrPlate = new PCRPlate(parent, 2048);
        this.pcrPlate.setLayoutData(new GridData(1808));
    }

    private void fireUpdate(Display display, final Object data) {
        if (display != null) {
            final String topic = data instanceof IWell ? "well/pcr/update/selection" : "well/pcr/unload/selection";
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IEventBroker eventBroker = Activator.getDefault().getEventBroker();
                    eventBroker.send(topic, data instanceof IWell ? data : null);
                }
            });
        }
    }

    private void updateWidget() {
        this.updateInfo();
        this.updateWellPositions();
        this.updateSubsetCombo();
        this.updateChannelSpecifications();
    }

    private void updateInfo() {
        if (this.plate != null) {
            this.labelDataInfo.setText("Number of Wells: " + this.plate.getWells().size());
        } else {
            this.labelDataInfo.setText("");
        }
    }

    private void updateWellPositions() {
        if (this.plate != null) {
            this.pcrPlate.setPlate(this.plate);
        } else {
            this.pcrPlate.setPlate(null);
        }
    }

    private void updateSubsetCombo() {
        if (this.plate != null) {
            int selectionIndex = this.comboSubsets.getSelectionIndex();
            List subsets = this.plate.getSampleSubsets();
            this.comboSubsets.setItems(subsets.toArray(new String[subsets.size()]));
            this.setComboSelection(subsets, this.comboSubsets, selectionIndex);
        } else {
            this.comboSubsets.setItems(new String[]{""});
        }
    }

    private void updateChannelSpecifications() {
        if (this.plate != null) {
            int selectionIndex = this.comboChannels.getSelectionIndex();
            List channels = this.plate.getActiveChannels();
            channels.add(0, "All Channels");
            this.comboChannels.setItems(channels.toArray(new String[channels.size()]));
            this.setComboSelection(channels, this.comboChannels, selectionIndex);
        } else {
            this.comboChannels.setItems(new String[]{""});
        }
    }

    private void setComboSelection(List<String> items, Combo combo, int selectionIndex) {
        if (items.size() > 0) {
            if (selectionIndex < 0) {
                combo.select(0);
            } else if (selectionIndex < items.size()) {
                combo.select(selectionIndex);
            }
        }
    }
}

