/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import org.eclipse.chemclipse.model.selection.ChromatogramSelectionSupport;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.selection.MoveDirection;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedChromatogramUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class ChromatogramMoveArrowKeyHandler
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private ExtendedChromatogramUI extendedChromatogramUI;
    private int keyCode;

    public ChromatogramMoveArrowKeyHandler(ExtendedChromatogramUI extendedChromatogramUI, int keyCode) {
        this.extendedChromatogramUI = extendedChromatogramUI;
        this.keyCode = keyCode;
    }

    public int getEvent() {
        return 7;
    }

    public int getButton() {
        return this.keyCode;
    }

    public int getStateMask() {
        return 0;
    }

    public void handleEvent(BaseChart baseChart, Event event) {
        this.handleArrowMoveWindowSelection(this.keyCode);
    }

    private void handleArrowMoveWindowSelection(int keyCode) {
        IChromatogramSelection chromatogramSelection = this.extendedChromatogramUI.getChromatogramSelection();
        if (chromatogramSelection != null) {
            if (keyCode == 0x1000004 || keyCode == 0x1000003) {
                boolean useAlternateWindowMoveDirection = this.preferenceStore.getBoolean("useAlternateWindowMoveDirection");
                if (keyCode == 0x1000004) {
                    MoveDirection moveDirection = useAlternateWindowMoveDirection ? MoveDirection.LEFT : MoveDirection.RIGHT;
                    ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)moveDirection, (int)20);
                } else {
                    MoveDirection moveDirection = useAlternateWindowMoveDirection ? MoveDirection.RIGHT : MoveDirection.LEFT;
                    ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)moveDirection, (int)20);
                }
                this.extendedChromatogramUI.updateSelection();
            } else if (keyCode == 0x1000001 || keyCode == 0x1000002) {
                float stopAbundance = chromatogramSelection.getStopAbundance();
                float newStopAbundance = PreferenceSupplier.useAlternateWindowMoveDirection() ? (keyCode == 0x1000001 ? stopAbundance - stopAbundance / 20.0f : stopAbundance + stopAbundance / 20.0f) : (keyCode == 0x1000001 ? stopAbundance + stopAbundance / 20.0f : stopAbundance - stopAbundance / 20.0f);
                int startRetentionTime = chromatogramSelection.getStartRetentionTime();
                int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
                float startAbundance = chromatogramSelection.getStartAbundance();
                this.extendedChromatogramUI.setChromatogramSelectionRange(startRetentionTime, stopRetentionTime, startAbundance, newStopAbundance);
                this.extendedChromatogramUI.updateSelection();
            }
        }
    }
}

