/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.IMassSpectrumIdentifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.IMassSpectrumIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.MassSpectrumIdentifier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.IUpdateListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.MassSpectrumIdentifierRunnable;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ScanIdentifierUI
extends Composite {
    private static final Logger logger = Logger.getLogger(ScanIdentifierUI.class);
    private ComboViewer comboViewer;
    private Button button;
    private IScan scan = null;
    private IUpdateListener updateListener = null;

    public ScanIdentifierUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setInput(IScan scan) {
        this.scan = scan;
        boolean enabled = scan instanceof IScanMSD;
        this.comboViewer.getCombo().setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void setUpdateListener(IUpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.comboViewer = this.createComboViewer(composite);
        this.button = this.createButton(composite);
        IMassSpectrumIdentifierSupport massSpectrumIdentifierSupport = MassSpectrumIdentifier.getMassSpectrumIdentifierSupport();
        Collection suppliers = massSpectrumIdentifierSupport.getSuppliers();
        this.comboViewer.setInput((Object)suppliers);
        if (suppliers.size() > 0) {
            this.comboViewer.getCombo().select(0);
        }
    }

    private ComboViewer createComboViewer(Composite parent) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IMassSpectrumIdentifierSupplier) {
                    IMassSpectrumIdentifierSupplier supplier = (IMassSpectrumIdentifierSupplier)element;
                    return supplier.getIdentifierName();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a scan identifier.");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 200;
        combo.setLayoutData((Object)gridData);
        return comboViewer;
    }

    private Button createButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Identify the currently selected scan.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ScanIdentifierUI.this.scan instanceof IScanMSD) {
                    IScanMSD scanMSD = (IScanMSD)ScanIdentifierUI.this.scan;
                    IScanMSD optimizedMassSpectrum = scanMSD.getOptimizedMassSpectrum();
                    IScanMSD massSpectrum = optimizedMassSpectrum != null ? optimizedMassSpectrum : scanMSD;
                    Object object = ScanIdentifierUI.this.comboViewer.getStructuredSelection().getFirstElement();
                    if (object instanceof IMassSpectrumIdentifierSupplier) {
                        IMassSpectrumIdentifierSupplier supplier = (IMassSpectrumIdentifierSupplier)object;
                        MassSpectrumIdentifierRunnable runnable = new MassSpectrumIdentifierRunnable(massSpectrum, supplier.getId());
                        ProgressMonitorDialog monitor = new ProgressMonitorDialog(e.display.getActiveShell());
                        try {
                            monitor.run(true, true, (IRunnableWithProgress)runnable);
                            ScanIdentifierUI.this.fireUpdate();
                        }
                        catch (InvocationTargetException e1) {
                            logger.warn((Object)e1);
                        }
                        catch (InterruptedException e1) {
                            logger.warn((Object)e1);
                        }
                    }
                }
            }
        });
        return button;
    }

    private void fireUpdate() {
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }
}

