/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.List;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.QuantCompoundEditingSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.QuantCompoundLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.QuantCompoundListFilter;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.QuantCompoundTableComparator;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class QuantCompoundListUI
extends ExtendedTableViewer {
    private String[] titles = QuantCompoundLabelProvider.TITLES;
    private int[] bounds = QuantCompoundLabelProvider.BOUNDS;
    private IBaseLabelProvider labelProvider = new QuantCompoundLabelProvider();
    private ViewerComparator tableComparator = new QuantCompoundTableComparator();
    private QuantCompoundListFilter viewerFilter = new QuantCompoundListFilter();
    private IQuantitationDatabase quantitationDatabase;

    public QuantCompoundListUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    public void setQuantitationDatabase(IQuantitationDatabase quantitationDatabase) {
        this.quantitationDatabase = quantitationDatabase;
    }

    public boolean containsName(String name) {
        if (this.quantitationDatabase != null) {
            return this.quantitationDatabase.containsQuantitationCompund(name);
        }
        return false;
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.viewerFilter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    public void clear() {
        this.setInput(null);
    }

    private void createColumns() {
        this.createColumns(this.titles, this.bounds);
        this.setLabelProvider(this.labelProvider);
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setComparator(this.tableComparator);
        this.setFilters(new ViewerFilter[]{this.viewerFilter});
        this.setEditingSupport();
    }

    private void setEditingSupport() {
        List tableViewerColumns = this.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            tableViewerColumn.setEditingSupport((EditingSupport)new QuantCompoundEditingSupport(this, label));
            ++i;
        }
    }
}

