/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.List;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.NamedTracesComparator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.NamedTracesEditingSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.NamedTracesFilter;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.NamedTracesLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class NamedTracesListUI
extends ExtendedTableViewer {
    private static final String[] TITLES = NamedTracesLabelProvider.TITLES;
    private static final int[] BOUNDS = NamedTracesLabelProvider.BOUNDS;
    private ITableLabelProvider labelProvider = new NamedTracesLabelProvider();
    private ViewerComparator tableComparator = new NamedTracesComparator();
    private NamedTracesFilter listFilter = new NamedTracesFilter();

    public NamedTracesListUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.listFilter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.setComparator(sortEnabled ? this.tableComparator : null);
    }

    public void clear() {
        this.setInput(null);
    }

    private void createColumns() {
        this.createColumns(TITLES, BOUNDS);
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setComparator(this.tableComparator);
        this.setFilters(new ViewerFilter[]{this.listFilter});
        this.setEditingSupport();
    }

    private void setEditingSupport() {
        List tableViewerColumns = this.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (!label.equals("Identifier")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new NamedTracesEditingSupport(this, label));
            }
            ++i;
        }
    }
}

