/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMeasurementInfo;
import org.eclipse.chemclipse.model.exceptions.InvalidHeaderModificationException;
import org.eclipse.chemclipse.nmr.model.selection.IDataNMRSelection;
import org.eclipse.chemclipse.pcr.model.core.IPlate;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.HeaderDataListUI;
import org.eclipse.chemclipse.xir.model.core.IScanXIR;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExtendedHeaderDataUI {
    private static final String MENU_CATEGORY_HEADER_ENTRIES = "Header Entries";
    private static final String HEADER_ENTRY = "Header Entry";
    private Label labelInfo;
    private Composite toolbarInfo;
    private Composite toolbarSearch;
    private Composite toolbarModify;
    private Button buttonToggleEditModus;
    private Text textHeaderKey;
    private Text textHeaderValue;
    private Button buttonAddHeaderEntry;
    private Button buttonDeleteHeaderEntry;
    private HeaderDataListUI headerDataListUI;
    private IMeasurementInfo measurementInfo;
    private boolean editable;

    @Inject
    public ExtendedHeaderDataUI(Composite parent) {
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updateHeaderData();
    }

    public void update(IMeasurementInfo measurementInfo) {
        this.measurementInfo = measurementInfo;
        this.editable = this.isEditable(measurementInfo);
        this.updateHeaderData();
    }

    private boolean isEditable(IMeasurementInfo measurementInfo) {
        if (measurementInfo instanceof IChromatogram) {
            return true;
        }
        if (measurementInfo instanceof IScanXIR) {
            return true;
        }
        if (measurementInfo instanceof IDataNMRSelection) {
            return true;
        }
        return measurementInfo instanceof IPlate;
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.toolbarSearch = this.createToolbarSearch(parent);
        this.toolbarModify = this.createToolbarModify(parent);
        this.headerDataListUI = this.createHeaderDataTable(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarSearch, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarModify, (boolean)false);
        this.headerDataListUI.setEditEnabled(false);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createButtonToggleToolbarSearch(composite);
        this.createButtonToggleToolbarModify(composite);
        this.buttonToggleEditModus = this.createButtonToggleEditModus(composite);
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedHeaderDataUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedHeaderDataUI.this.toolbarSearch);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarModify(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle modify toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedHeaderDataUI.this.toolbarModify);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleEditModus(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editEnabled = !ExtendedHeaderDataUI.this.headerDataListUI.isEditEnabled();
                ExtendedHeaderDataUI.this.headerDataListUI.setEditEnabled(editEnabled);
                button.setImage(ApplicationImageFactory.getInstance().getImage(editEnabled ? "org.eclipse.chemclipse.rcp.ui.icons/editEntryActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
                ExtendedHeaderDataUI.this.updateLabel();
            }
        });
        return button;
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarSearch(Composite parent) {
        SearchSupportUI searchSupportUI = new SearchSupportUI(parent, 0);
        searchSupportUI.setLayoutData((Object)new GridData(768));
        searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                ExtendedHeaderDataUI.this.headerDataListUI.setSearchText(searchText, caseSensitive);
            }
        });
        return searchSupportUI;
    }

    private Composite createToolbarModify(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.textHeaderKey = this.createTextHeaderKey(composite);
        this.textHeaderValue = this.createTextHeaderValue(composite);
        this.buttonAddHeaderEntry = this.createButtonAdd(composite);
        this.buttonDeleteHeaderEntry = this.createButtonDelete(composite);
        return composite;
    }

    private Text createTextHeaderKey(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Set a new header key.");
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private Text createTextHeaderValue(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Set a new header value.");
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Add the header entry.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedHeaderDataUI.this.addHeaderEntry(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete the selected header entrie(s).");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedHeaderDataUI.this.deleteHeaderEntries(e.display.getActiveShell());
            }
        });
        return button;
    }

    private HeaderDataListUI createHeaderDataTable(Composite parent) {
        HeaderDataListUI measuremntListUI = new HeaderDataListUI(parent, 68354);
        measuremntListUI.getTable().setLayoutData((Object)new GridData(1808));
        Shell shell = measuremntListUI.getTable().getShell();
        ITableSettings tableSettings = measuremntListUI.getTableSettings();
        this.addDeleteMenuEntry(shell, tableSettings);
        measuremntListUI.applySettings(tableSettings);
        return measuremntListUI;
    }

    private void addDeleteMenuEntry(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Delete Header Entrie(s)";
            }

            public String getCategory() {
                return ExtendedHeaderDataUI.MENU_CATEGORY_HEADER_ENTRIES;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedHeaderDataUI.this.deleteHeaderEntries(shell);
            }
        });
    }

    private void addHeaderEntry(Shell shell) {
        if (this.measurementInfo != null) {
            String key = this.textHeaderKey.getText().trim();
            String value = this.textHeaderValue.getText().trim();
            if ("".equals(key)) {
                MessageDialog.openError((Shell)shell, (String)HEADER_ENTRY, (String)"The header key must be not empty.");
            } else if (this.measurementInfo.headerDataContainsKey(key)) {
                MessageDialog.openError((Shell)shell, (String)HEADER_ENTRY, (String)"The header key already exists.");
            } else if ("".equals(value)) {
                MessageDialog.openError((Shell)shell, (String)HEADER_ENTRY, (String)"The header value must be not empty.");
            } else {
                this.measurementInfo.putHeaderData(key, value);
                this.textHeaderKey.setText("");
                this.textHeaderValue.setText("");
                this.updateHeaderData();
            }
        }
    }

    private void deleteHeaderEntries(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText("Header Entrie(s)");
        messageBox.setMessage("Would you like to delete the selected header entrie(s)?");
        if (messageBox.open() == 64 && this.measurementInfo != null) {
            Iterator iterator = this.headerDataListUI.getStructuredSelection().iterator();
            HashSet<String> keysNotRemoved = new HashSet<String>();
            while (iterator.hasNext()) {
                Object mapObject = iterator.next();
                if (!(mapObject instanceof Map.Entry)) continue;
                Map.Entry entry = (Map.Entry)mapObject;
                String key = (String)entry.getKey();
                try {
                    this.measurementInfo.removeHeaderData(key);
                }
                catch (InvalidHeaderModificationException e) {
                    keysNotRemoved.add(key);
                }
            }
            if (keysNotRemoved.size() > 0) {
                MessageDialog.openWarning((Shell)DisplayUtils.getShell(), (String)HEADER_ENTRY, (String)("The following keys can't be removed: " + keysNotRemoved));
            }
            this.updateHeaderData();
        }
    }

    private void updateHeaderData() {
        this.updateWidgets();
        this.updateLabel();
        this.headerDataListUI.sortTable();
        Table table = this.headerDataListUI.getTable();
        if (table.getItemCount() > 0) {
            table.setSelection(0);
        }
    }

    private void updateLabel() {
        if (this.measurementInfo != null) {
            this.labelInfo.setText("Number of Entries: " + this.measurementInfo.getHeaderDataMap().size());
            this.headerDataListUI.setInput(this.measurementInfo);
            String editInformation = this.headerDataListUI.isEditEnabled() ? "Edit is enabled." : "Edit is disabled.";
            this.labelInfo.setText(String.valueOf(this.labelInfo.getText()) + " - " + editInformation);
        } else {
            this.labelInfo.setText("");
            this.headerDataListUI.setInput(null);
        }
    }

    private void updateWidgets() {
        boolean enabled = this.editable;
        this.buttonToggleEditModus.setEnabled(enabled);
        this.textHeaderKey.setEnabled(enabled);
        this.textHeaderValue.setEnabled(enabled);
        this.buttonAddHeaderEntry.setEnabled(enabled);
        this.buttonDeleteHeaderEntry.setEnabled(enabled);
    }
}

