/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.List;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.ColorCodeLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.model.ColorCode;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;

public class ColorCodeTableUI
extends ExtendedTableViewer {
    public ColorCodeTableUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    public void clear() {
        this.setInput(null);
    }

    private void createColumns() {
        this.createColumns(ColorCodeLabelProvider.TITLES, ColorCodeLabelProvider.BOUNDS);
        this.setLabelProvider((IBaseLabelProvider)new ColorCodeLabelProvider());
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setCellColorProvider();
    }

    private void setCellColorProvider() {
        List tableViewerColumns = this.getTableViewerColumns();
        TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(1);
        if (tableViewerColumn != null) {
            tableViewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (cell != null) {
                        ColorCode colorCode = (ColorCode)cell.getElement();
                        cell.setBackground(colorCode.getColor());
                        cell.setForeground(Colors.WHITE);
                        cell.setText(colorCode.getColor().toString());
                        super.update(cell);
                    }
                }
            });
        }
    }
}

