/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.pcr.model.core.IWell;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedWellChartUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;

public class WellChartPart
extends AbstractDataUpdateSupport
implements IDataUpdateSupport {
    private ExtendedWellChartUI extendedWellChartUI;

    @Inject
    public WellChartPart(Composite parent, MPart part) {
        super(part);
        this.extendedWellChartUI = new ExtendedWellChartUI(parent);
    }

    @Focus
    public void setFocus() {
        this.updateObjects(this.getObjects(), this.getTopic());
    }

    @Override
    public void registerEvents() {
        this.registerEvent("well/pcr/update/selection", "org.eclipse.e4.data");
        this.registerEvent("well/pcr/unload/selection", "org.eclipse.e4.data");
        this.registerEvent("plate/pcr/unload/selection", "org.eclipse.e4.data");
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        if (objects.size() == 1) {
            if (this.isUnloadEvent(topic)) {
                this.extendedWellChartUI.update(null);
            } else {
                Object object = objects.get(0);
                if (object instanceof IWell) {
                    this.extendedWellChartUI.update((IWell)object);
                } else {
                    this.extendedWellChartUI.update(null);
                }
            }
        }
    }

    private boolean isUnloadEvent(String topic) {
        return topic.equals("well/pcr/unload/selection") || topic.equals("plate/pcr/unload/selection");
    }
}

