/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class RetentionTimeValidator
implements IValidator {
    private static final String ERROR = "Please enter a correct retention time in minutes, e.g. 4.25";
    private static final String ERROR_VALUE_RANGE = "The retention time must be not <= 0.";
    private double retentionTime = 0.0;

    public IStatus validate(Object value) {
        String message;
        block8: {
            message = null;
            this.retentionTime = 0.0;
            if (value == null) {
                message = ERROR;
            } else if (value instanceof String) {
                try {
                    double retentionTime = Double.parseDouble(((String)value).trim());
                    if (retentionTime <= 0.0) {
                        message = ERROR_VALUE_RANGE;
                        break block8;
                    }
                    this.retentionTime = retentionTime;
                }
                catch (NumberFormatException e) {
                    message = ERROR;
                }
            } else {
                message = ERROR;
            }
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    public double getRetentionTime() {
        return this.retentionTime;
    }
}

