/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.converter.model.reports.ISequence;
import org.eclipse.chemclipse.converter.model.reports.ISequenceRecord;
import org.eclipse.chemclipse.converter.sequence.SequenceConverter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SequenceImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(SequenceImportRunnable.class);
    private File file;
    private ISequence<? extends ISequenceRecord> sequence;

    public SequenceImportRunnable(File file) {
        this.file = file;
    }

    public ISequence<? extends ISequenceRecord> getSequence() {
        return this.sequence;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Read Sequence", (int)2);
        try {
            try {
                subMonitor.worked(1);
                IProcessingInfo processingInfo = SequenceConverter.convert((File)this.file, (IProgressMonitor)monitor);
                this.sequence = (ISequence)processingInfo.getProcessingResult();
                subMonitor.worked(2);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
    }
}

