/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.ILibraryService;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.LibraryService;
import org.eclipse.chemclipse.model.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class LibraryServiceRunnable
implements IRunnableWithProgress {
    private final IIdentificationTarget identificationTarget;
    private final List<ILibraryService> libraryServices = new ArrayList<ILibraryService>();
    private final Consumer<IScanMSD> libraryMassSpectrumConsumer;

    public LibraryServiceRunnable(IIdentificationTarget identificationTarget, Consumer<IScanMSD> libraryMassSpectrumConsumer) {
        this.identificationTarget = identificationTarget;
        this.libraryMassSpectrumConsumer = libraryMassSpectrumConsumer;
        IScanMSD adaptedTarget = (IScanMSD)Adapters.adapt((Object)identificationTarget, IScanMSD.class);
        if (adaptedTarget != null) {
            libraryMassSpectrumConsumer.accept(adaptedTarget);
        } else {
            try {
                List ids = LibraryService.getLibraryServiceSupport().getAvailableIdentifierIds();
                for (String id : ids) {
                    ILibraryService libraryService = LibraryService.getLibraryService((String)id);
                    if (libraryService == null || !libraryService.accepts(identificationTarget)) continue;
                    this.libraryServices.add(libraryService);
                }
            }
            catch (NoIdentifierAvailableException noIdentifierAvailableException) {
                // empty catch block
            }
            if (this.libraryServices.isEmpty()) {
                libraryMassSpectrumConsumer.accept(null);
            }
        }
    }

    public boolean requireProgressMonitor() {
        for (ILibraryService s : this.libraryServices) {
            if (!s.requireProgressMonitor()) continue;
            return true;
        }
        return false;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.libraryServices.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Library Service", (int)(100 * this.libraryServices.size()));
        for (ILibraryService libraryService : this.libraryServices) {
            try {
                IProcessingInfo processingInfo = libraryService.identify(this.identificationTarget, (IProgressMonitor)subMonitor.split(100));
                IMassSpectra massSpectra = (IMassSpectra)processingInfo.getProcessingResult();
                if (massSpectra == null || massSpectra.size() <= 0) continue;
                this.libraryMassSpectrumConsumer.accept(massSpectra.getMassSpectrum(1));
                return;
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "Fetching mass spectrum failed!", (Throwable)e));
            }
        }
        this.libraryMassSpectrumConsumer.accept(null);
    }
}

