/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.handlers;

import java.util.List;
import javax.inject.Named;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DeleteAllQuantitationsHandler
implements EventHandler {
    private static IChromatogramSelection chromatogramSelection;
    private ChromatogramDataSupport chromatogramDataSupport = new ChromatogramDataSupport();

    @Execute
    public void execute(UISynchronize uiSynchronize, @Named(value="activeShell") Shell shell) {
        IChromatogram chromatogram;
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogram()) != null) {
            MessageBox messageBox = new MessageBox(shell, 456);
            messageBox.setText("Delete All Quantitations");
            messageBox.setMessage("Do you really want to delete all quantitations?");
            int decision = messageBox.open();
            if (64 == decision) {
                List<IPeak> peaks = ChromatogramDataSupport.getPeaks(chromatogram);
                for (IPeak peak : peaks) {
                    peak.removeAllQuantitationEntries();
                }
                chromatogramSelection.update(true);
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelection)event.getProperty("ChromatogramSelection");
        } else if (event.getTopic().equals("chromatogram/csd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelection)event.getProperty("ChromatogramSelection");
        } else if (event.getTopic().equals("chromatogram/wsd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelection)event.getProperty("ChromatogramSelection");
        }
    }
}

