/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.handlers;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.inject.Named;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.ux.extension.ui.provider.ISupplierFileEditorSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.InputEntriesWizard;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.InputWizardSettings;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractOpenHandler {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell) {
        DataType dataType = this.getDataType();
        InputWizardSettings inputWizardSettings = InputWizardSettings.create(Activator.getDefault().getPreferenceStore(), this.getPreferenceKey(), this.getDataType());
        inputWizardSettings.setTitle("Open " + dataType + " Files");
        inputWizardSettings.setDescription("You can select one or more files to be opened.");
        Map<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> selected = InputEntriesWizard.openWizard(shell, inputWizardSettings);
        for (Map.Entry<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> entry : selected.entrySet()) {
            File file = entry.getKey();
            block1: for (Map.Entry<ISupplierFileIdentifier, Collection<ISupplier>> supplier : entry.getValue().entrySet()) {
                ISupplierFileIdentifier identifier = supplier.getKey();
                if (!(identifier instanceof ISupplierFileEditorSupport)) continue;
                for (ISupplier converter : supplier.getValue()) {
                    if (((ISupplierFileEditorSupport)identifier).openEditor(file, converter)) continue block1;
                }
            }
        }
    }

    protected abstract DataType getDataType();

    protected abstract String getPreferenceKey();
}

