/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.charts;

import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChartSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.extensions.axisconverter.MillisecondsToMinuteConverter;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.linecharts.LineChart;

public class PeaksChart
extends LineChart {
    private static final String TITLE_X_AXIS_MILLISECONDS = "Retention Time (milliseconds)";
    private static final String TITLE_X_AXIS_MINUTES = "Minutes";
    private static final String TITLE_Y_AXIS_INTENSITY = "Intensity";
    private static final String TITLE_Y_AXIS_RELATIVE_INTENSITY = "Relative Intensity [%]";
    private ChartSupport chartSupport = new ChartSupport(Activator.getDefault().getPreferenceStore());

    public PeaksChart() {
        this.initialize();
    }

    public PeaksChart(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(false);
        chartSettings.setVerticalSliderVisible(false);
        chartSettings.getRangeRestriction().setZeroX(true);
        chartSettings.getRangeRestriction().setZeroY(true);
        chartSettings.setCreateMenu(true);
        this.modifyAxes(true);
    }

    public void modifyAxes(boolean applySettings) {
        this.modifyXAxisMilliseconds();
        this.modifyXAxisMinutes();
        this.modifyYAxisResponse();
        this.modifyYAxisRelativeResponse();
        if (applySettings) {
            IChartSettings chartSettings = this.getChartSettings();
            this.applySettings(chartSettings);
        }
    }

    private void modifyXAxisMilliseconds() {
        IChartSettings chartSettings = this.getChartSettings();
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle(TITLE_X_AXIS_MILLISECONDS);
        String positionNode = "positionXAxisMillisecondsPeaks";
        String pattern = "0.0##";
        String colorNode = "colorXAxisMillisecondsPeaks";
        String gridLineStyleNode = "gridlineStyleXAxisMillisecondsPeaks";
        String gridColorNode = "gridlineColorXAxisMillisecondsPeaks";
        boolean isShowAxis = this.chartSupport.getBoolean("showXAxisMillisecondsPeaks");
        this.chartSupport.setAxisSettings((IAxisSettings)primaryAxisSettingsX, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
        primaryAxisSettingsX.setVisible(isShowAxis);
    }

    private void modifyYAxisResponse() {
        IChartSettings chartSettings = this.getChartSettings();
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle(TITLE_Y_AXIS_INTENSITY);
        String positionNode = "positionYAxisIntensityPeaks";
        String pattern = "0.0#E0";
        String colorNode = "colorYAxisIntensityPeaks";
        String gridLineStyleNode = "gridlineStyleYAxisIntensityPeaks";
        String gridColorNode = "gridlineColorYAxisIntensityPeaks";
        boolean isShowAxis = this.chartSupport.getBoolean("showYAxisIntensityPeaks");
        this.chartSupport.setAxisSettings((IAxisSettings)primaryAxisSettingsY, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
        primaryAxisSettingsY.setVisible(isShowAxis);
    }

    private void modifyXAxisMinutes() {
        IChartSettings chartSettings = this.getChartSettings();
        ISecondaryAxisSettings axisSettings = this.chartSupport.getSecondaryAxisSettingsX(TITLE_X_AXIS_MINUTES, chartSettings);
        String positionNode = "positionXAxisMinutesPeaks";
        String pattern = "0.00";
        String colorNode = "colorXAxisMinutesPeaks";
        String gridLineStyleNode = "gridlineStyleXAxisMinutesPeaks";
        String gridColorNode = "gridlineColorXAxisMinutesPeaks";
        boolean isShowAxis = this.chartSupport.getBoolean("showXAxisMinutesPeaks");
        if (isShowAxis) {
            if (axisSettings == null) {
                SecondaryAxisSettings secondaryAxisSettingsX = new SecondaryAxisSettings(TITLE_X_AXIS_MINUTES, (IAxisScaleConverter)new MillisecondsToMinuteConverter());
                this.chartSupport.setAxisSettings((IAxisSettings)secondaryAxisSettingsX, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                chartSettings.getSecondaryAxisSettingsListX().add(secondaryAxisSettingsX);
            } else {
                this.chartSupport.setAxisSettings((IAxisSettings)axisSettings, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                axisSettings.setVisible(true);
            }
        } else if (axisSettings != null) {
            axisSettings.setVisible(false);
        }
    }

    private void modifyYAxisRelativeResponse() {
        IChartSettings chartSettings = this.getChartSettings();
        ISecondaryAxisSettings axisSettings = this.chartSupport.getSecondaryAxisSettingsY(TITLE_Y_AXIS_RELATIVE_INTENSITY, chartSettings);
        String positionNode = "positionYAxisRelativeIntensityPeaks";
        String pattern = "0.00";
        String colorNode = "colorYAxisRelativeIntensityPeaks";
        String gridLineStyleNode = "gridlineStyleYAxisRelativeIntensityPeaks";
        String gridColorNode = "gridlineColorYAxisRelativeIntensityPeaks";
        boolean isShowAxis = this.chartSupport.getBoolean("showYAxisRelativeIntensityPeaks");
        if (isShowAxis) {
            if (axisSettings == null) {
                SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings(TITLE_Y_AXIS_RELATIVE_INTENSITY, (IAxisScaleConverter)new PercentageConverter(512, true));
                this.chartSupport.setAxisSettings((IAxisSettings)secondaryAxisSettingsY, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
            } else {
                this.chartSupport.setAxisSettings((IAxisSettings)axisSettings, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                axisSettings.setVisible(true);
            }
        } else if (axisSettings != null) {
            axisSettings.setVisible(false);
        }
    }
}

