/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.Executors;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.support.ui.workbench.PerspectiveSupport;
import org.eclipse.chemclipse.ux.extension.ui.definitions.TileDefinition;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.graphics.Image;

public class DemoWelcomeTile
implements TileDefinition {
    private File chromatogramFile;

    @Execute
    public void handleEvent(final EModelService modelService, final MApplication application, final EPartService partService, PerspectiveSupport perspectiveSupport) {
        perspectiveSupport.changePerspective("org.eclipse.chemclipse.ux.extension.xxd.ui.perspective.main");
        Executors.defaultThreadFactory().newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DemoWelcomeTile demoWelcomeTile = DemoWelcomeTile.this;
                synchronized (demoWelcomeTile) {
                    if (DemoWelcomeTile.this.chromatogramFile == null) {
                        try {
                            File tempFile = File.createTempFile("DemoChromatogram", ".ocb");
                            tempFile.deleteOnExit();
                            DemoWelcomeTile.this.copyChromatogram(tempFile);
                            DemoWelcomeTile.this.chromatogramFile = tempFile;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                    DisplayUtils.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (DemoWelcomeTile.this.chromatogramFile != null && DemoWelcomeTile.this.chromatogramFile.exists()) {
                                    MPart part = DemoWelcomeTile.this.createChromatogramPart();
                                    part.setLabel("DemoChromatogram.ocb");
                                    HashMap<String, Object> map = new HashMap<String, Object>();
                                    map.put("File", DemoWelcomeTile.this.chromatogramFile.getAbsolutePath());
                                    map.put("Batch", false);
                                    part.setObject(map);
                                    part.setTooltip("Demo Chromatogram (MSD)");
                                    DemoWelcomeTile.this.showEditorPart(part, modelService, application, partService);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return;
                            }
                        }
                    });
                }
            }
        }).start();
    }

    void showEditorPart(MPart part, EModelService modelService, MApplication application, EPartService partService) {
        MPartStack partStack = (MPartStack)modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)application);
        partStack.getChildren().add(part);
        partService.showPart(part, EPartService.PartState.ACTIVATE);
    }

    MPart createChromatogramPart() {
        MPart part = MBasicFactory.INSTANCE.createPart();
        part.setElementId("org.eclipse.chemclipse.ux.extension.xxd.ui.part.chromatogramEditorMSD");
        part.setContributionURI("bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.ChromatogramEditorMSD");
        part.setIconURI("platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif");
        part.setCloseable(true);
        return part;
    }

    private void copyChromatogram(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = DemoWelcomeTile.class.getResourceAsStream("/files/DemoChromatogram.ocb");){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (FileOutputStream fout = new FileOutputStream(file);){
                int read;
                byte[] buffer = new byte[1024];
                while ((read = stream.read(buffer)) > -1) {
                    fout.write(buffer, 0, read);
                }
                fout.flush();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public String getTitle() {
        return "Demo";
    }

    @Override
    public String getDescription() {
        return "Load a demo chromatogram.";
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public String getContext() {
        return "WelcomeView.Main";
    }
}

