/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.settings.validation;

import java.io.File;
import org.eclipse.chemclipse.support.settings.FileSettingProperty;
import org.eclipse.chemclipse.support.settings.parser.InputValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class InputValidator
implements IValidator {
    private static final String ERROR = "Please enter a value.";
    private final InputValue inputValue;

    public InputValidator(InputValue inputValue) {
        this.inputValue = inputValue;
    }

    public IStatus validate(Object value) {
        String message = null;
        if (value == null) {
            message = ERROR;
        } else {
            Class<?> rawType = this.inputValue.getRawType();
            if (rawType != null) {
                message = this.parse(rawType, value.toString());
            }
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    private String parse(Class<?> rawType, String value) {
        String message = null;
        try {
            FileSettingProperty property;
            if (rawType == Boolean.TYPE || rawType == Boolean.class) {
                Boolean.parseBoolean(value);
            } else if (rawType.isEnum()) {
                if ("".equals(value)) {
                    message = "Please select and option from the combo box.";
                }
            } else if (rawType == File.class && (property = this.inputValue.getFileSettingProperty()) != null && property.dialogType() != FileSettingProperty.DialogType.SAVE_DIALOG && value != null && !value.isEmpty() && !new File(value).exists()) {
                return "Location does not exits, please choose a valid location";
            }
        }
        catch (NumberFormatException e) {
            message = ERROR;
        }
        return message;
    }
}

