/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.wizards;

import java.util.ArrayList;
import org.eclipse.chemclipse.support.l10n.Messages;
import org.eclipse.chemclipse.support.messages.SupportMessages;
import org.eclipse.chemclipse.support.ui.internal.provider.ProjectContentProvider;
import org.eclipse.chemclipse.support.ui.internal.provider.ProjectLabelProvider;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.chemclipse.support.ui.wizards.IWizardElements;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectProjectWizardPage
extends AbstractExtendedWizardPage {
    private ISelection selection;
    private IWizardElements wizardElements;
    private Text projectNameText;
    private Button buttonSelectExistingProject;
    private Button buttonCreateNewProject;
    private Combo comboExistingProjects;
    private TreeViewer treeViewerProject;
    private IWorkspaceRoot workspaceRoot;

    public SelectProjectWizardPage(ISelection selection, IWizardElements wizardElements) {
        super("SelectProjectWizardPage");
        this.setTitle(SupportMessages.INSTANCE().getMessage("labelSelectCreateProject", new String[0]));
        this.setDescription(SupportMessages.INSTANCE().getMessage("labelSelectCreateProjectInfo", new String[0]));
        this.selection = selection;
        this.wizardElements = wizardElements;
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public boolean canFinish() {
        IContainer container = this.wizardElements.getContainer();
        return container != null;
    }

    @Override
    public void setDefaultValues() {
    }

    public void createControl(Composite parent) {
        Messages messages = SupportMessages.INSTANCE();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData(768);
        gridData.verticalIndent = 5;
        GridData gridDataTreeViewer = new GridData(768);
        gridDataTreeViewer.verticalIndent = 5;
        gridDataTreeViewer.heightHint = 200;
        this.buttonSelectExistingProject = new Button(composite, 16);
        this.buttonSelectExistingProject.setText(messages.getMessage("labelSelectExistingProject", new String[0]));
        this.buttonSelectExistingProject.setLayoutData((Object)gridData);
        this.buttonSelectExistingProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectWizardPage.this.enableWidgets(true);
                SelectProjectWizardPage.this.validateComboBoxSelection();
            }
        });
        String[] items = this.getProjectItems();
        this.comboExistingProjects = new Combo(composite, 8);
        this.comboExistingProjects.setItems(items);
        this.comboExistingProjects.setLayoutData((Object)gridData);
        this.comboExistingProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectWizardPage.this.updateExistingProjectSelection();
            }
        });
        this.treeViewerProject = new TreeViewer(composite, 0);
        this.treeViewerProject.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.treeViewerProject.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.treeViewerProject.getControl().setLayoutData((Object)gridDataTreeViewer);
        this.treeViewerProject.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = ((IStructuredSelection)event.getSelection()).getFirstElement();
                SelectProjectWizardPage.this.validateTreeViewSelection(object);
            }
        });
        this.treeViewerProject.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object object = ((IStructuredSelection)event.getSelection()).getFirstElement();
                SelectProjectWizardPage.this.validateTreeViewSelection(object);
            }
        });
        this.buttonCreateNewProject = new Button(composite, 16);
        this.buttonCreateNewProject.setText(messages.getMessage("labelCreateNewProject", new String[0]));
        this.buttonCreateNewProject.setLayoutData((Object)gridData);
        this.buttonCreateNewProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectWizardPage.this.enableWidgets(false);
                SelectProjectWizardPage.this.validateTextSelection();
            }
        });
        this.projectNameText = new Text(composite, 2048);
        this.projectNameText.setText("");
        this.projectNameText.setLayoutData((Object)new GridData(768));
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectProjectWizardPage.this.validateTextSelection();
            }
        });
        if (this.selection != null && !this.selection.isEmpty()) {
            IStructuredSelection structuredSelection;
            Object object;
            IContainer container = null;
            if (this.selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)this.selection).getFirstElement()) instanceof IResource) {
                if (object instanceof IContainer) {
                    container = (IContainer)object;
                } else {
                    IResource resource = (IResource)object;
                    container = resource.getParent();
                }
                if (container != null) {
                    IProject rootContainer = container.getProject();
                    if (rootContainer != null) {
                        this.comboExistingProjects.setText(rootContainer.getName());
                    }
                    this.treeViewerProject.setInput((Object)container);
                    this.wizardElements.setContainer(container);
                } else {
                    this.validateComboBoxSelection();
                }
            }
            this.buttonSelectExistingProject.setSelection(true);
            this.enableWidgets(true);
        } else {
            this.buttonCreateNewProject.setSelection(true);
            this.enableWidgets(false);
            this.validateTextSelection();
        }
        this.setControl((Control)composite);
    }

    private String[] getProjectItems() {
        IProject[] projects = this.workspaceRoot.getProjects();
        ArrayList<IProject> projectsAccessible = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                projectsAccessible.add(project);
            }
            ++n2;
        }
        String[] items = new String[projectsAccessible.size()];
        int counter = 0;
        for (IProject project : projectsAccessible) {
            items[counter++] = project.getName();
        }
        return items;
    }

    private void enableWidgets(boolean choice) {
        this.comboExistingProjects.setEnabled(choice);
        this.treeViewerProject.getControl().setEnabled(choice);
        this.projectNameText.setEnabled(!choice);
    }

    private void updateExistingProjectSelection() {
        Messages messages = SupportMessages.INSTANCE();
        String message = null;
        String projectName = this.comboExistingProjects.getText().trim();
        if (projectName == null || projectName.equals("")) {
            message = messages.getMessage("processingSelectProject", new String[0]);
        } else {
            IProject project = this.workspaceRoot.getProject(projectName);
            if (!project.exists()) {
                message = messages.getMessage("processingProjectNotExists", new String[0]);
            } else {
                this.treeViewerProject.setInput((Object)project);
                this.wizardElements.setContainer((IContainer)project);
            }
        }
        this.updateStatus(message);
    }

    private void validateTreeViewSelection(Object object) {
        Messages messages = SupportMessages.INSTANCE();
        String message = null;
        if (object instanceof IFolder) {
            IFolder folder = (IFolder)object;
            if (!folder.exists()) {
                message = messages.getMessage("processingSelectValidFolder", new String[0]);
            } else {
                this.wizardElements.setContainer((IContainer)folder);
            }
        } else {
            message = messages.getMessage("processingSelectValidProject", new String[0]);
        }
        this.updateStatus(message);
    }

    private void validateComboBoxSelection() {
        Messages messages = SupportMessages.INSTANCE();
        String message = null;
        String containerName = this.comboExistingProjects.getText().trim();
        if (containerName == null || containerName.equals("")) {
            message = messages.getMessage("processingSelectProject", new String[0]);
        } else {
            IProject project = this.workspaceRoot.getProject(containerName);
            if (!project.exists()) {
                message = messages.getMessage("processingProjectNotExists", new String[0]);
            } else {
                this.wizardElements.setContainer((IContainer)project);
            }
        }
        this.updateStatus(message);
    }

    private void validateTextSelection() {
        Messages messages = SupportMessages.INSTANCE();
        String message = null;
        String containerName = this.projectNameText.getText().trim();
        if (containerName == null || containerName.equals("")) {
            message = messages.getMessage("processingTypeProjectName", new String[0]);
        } else {
            IProject project = this.workspaceRoot.getProject(containerName);
            if (project.exists()) {
                message = messages.getMessage("processingProjectAlreadyExists", new String[0]);
            } else {
                this.wizardElements.setContainer((IContainer)project);
            }
        }
        this.updateStatus(message);
    }
}

