/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.chemclipse.support.ui.events.CopyToClipboardEvent;
import org.eclipse.chemclipse.support.ui.events.IKeyEventProcessor;
import org.eclipse.chemclipse.support.ui.menu.CopyClipboardHandler;
import org.eclipse.chemclipse.support.ui.menu.DeselectAllHandler;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.menu.SelectAllHandler;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;

public class TableSettings
implements ITableSettings {
    private boolean createMenu = true;
    private Set<ITableMenuEntry> menuEntries = new HashSet<ITableMenuEntry>();
    private Set<IKeyEventProcessor> keyEventProcessors;

    public TableSettings() {
        this.menuEntries.add(new SelectAllHandler());
        this.menuEntries.add(new DeselectAllHandler());
        this.menuEntries.add(new CopyClipboardHandler());
        this.keyEventProcessors = new HashSet<IKeyEventProcessor>();
        this.keyEventProcessors.add(new CopyToClipboardEvent());
    }

    @Override
    public boolean isCreateMenu() {
        return this.createMenu;
    }

    @Override
    public void setCreateMenu(boolean createMenu) {
        this.createMenu = createMenu;
    }

    @Override
    public void addMenuEntry(ITableMenuEntry menuEntry) {
        this.menuEntries.add(menuEntry);
    }

    @Override
    public void removeMenuEntry(ITableMenuEntry menuEntry) {
        this.menuEntries.remove(menuEntry);
    }

    @Override
    public Set<ITableMenuEntry> getMenuEntries() {
        return Collections.unmodifiableSet(this.menuEntries);
    }

    @Override
    public void clearMenuEntries() {
        this.menuEntries.clear();
    }

    @Override
    public void addKeyEventProcessor(IKeyEventProcessor keyEventProcessor) {
        this.keyEventProcessors.add(keyEventProcessor);
    }

    @Override
    public void removeKeyEventProcessor(IKeyEventProcessor keyEventProcessor) {
        this.keyEventProcessors.remove(this.keyEventProcessors);
    }

    @Override
    public Set<IKeyEventProcessor> getKeyEventProcessors() {
        return Collections.unmodifiableSet(this.keyEventProcessors);
    }

    @Override
    public void clearKeyEventProcessors() {
        this.keyEventProcessors.clear();
    }
}

