/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.support.ui.preferences.editors.TableViewerFieldEditor;
import org.eclipse.chemclipse.support.util.FileSettingUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class FileTableEditor
extends TableViewerFieldEditor<File> {
    private String[] filterExtensions;
    private FileSettingUtil fileSettingUtil;

    public FileTableEditor(String name, String labelText, String[] filterExtensions, Composite parent) {
        super(name, labelText, new String[]{"File Name", "File Path"}, new int[]{150, 200}, parent);
        this.filterExtensions = filterExtensions;
        this.fileSettingUtil = new FileSettingUtil();
    }

    @Override
    protected String createSavePreferences(List<File> values) {
        return this.fileSettingUtil.serialize(values);
    }

    @Override
    protected List<File> parseSavePreferences(String data) {
        return this.fileSettingUtil.deserialize(data);
    }

    @Override
    protected String convertColumnValue(File value, int indexColumn) {
        if (indexColumn == 0) {
            return value.getName();
        }
        return value.getAbsolutePath();
    }

    @Override
    protected List<File> getNewInputObject() {
        String file;
        ArrayList<File> files = new ArrayList<File>();
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        dialog.setText("Select File");
        if (this.filterExtensions != null) {
            dialog.setFilterExtensions(this.filterExtensions);
        }
        if ((file = dialog.open()) != null) {
            String[] names;
            String[] stringArray = names = dialog.getFileNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                files.add(new File(name));
                ++n2;
            }
        }
        return files;
    }

    @Override
    protected int compareValue(File value1, File value2, int indexColumn) {
        if (indexColumn == 0) {
            return value1.getName().compareTo(value2.getName());
        }
        return value1.getAbsoluteFile().compareTo(value2.getAbsoluteFile());
    }
}

