/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.editors;

import java.util.Arrays;
import org.eclipse.chemclipse.support.l10n.Messages;
import org.eclipse.chemclipse.support.messages.SupportMessages;
import org.eclipse.chemclipse.support.ui.preferences.editors.DilutionInputValidator;
import org.eclipse.chemclipse.support.util.DilutionListUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class DilutionListEditor
extends ListEditor {
    public DilutionListEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.initialize(parent);
    }

    protected String createList(String[] items) {
        DilutionListUtil dilutionListUtil = new DilutionListUtil();
        return dilutionListUtil.createList(items);
    }

    protected String getNewInputObject() {
        List list = this.getList();
        Messages messages = SupportMessages.INSTANCE();
        InputDialog dialog = new InputDialog(this.getShell(), messages.getMessage("labelDilution", new String[0]), messages.getMessage("labelAddDilution", new String[]{"1:10"}), "", (IInputValidator)new DilutionInputValidator(list));
        dialog.create();
        if (dialog.open() == 0) {
            String dilution = dialog.getValue();
            return this.addDilution(dilution, list);
        }
        return null;
    }

    private void initialize(Composite parent) {
        final Messages messages = SupportMessages.INSTANCE();
        Composite composite = this.getButtonBoxControl(parent);
        Button button = new Button(composite, 8);
        button.setText(messages.getMessage("labelClearDilutions", new String[0]));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = DilutionListEditor.this.getList();
                if (list != null) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageBox messageBox = new MessageBox(shell, 448);
                    messageBox.setText(messages.getMessage("labelDeleteDilution", new String[0]));
                    messageBox.setMessage(messages.getMessage("labelQuestionDeleteDilutions", new String[0]));
                    int decision = messageBox.open();
                    if (decision == 64) {
                        list.removeAll();
                    }
                }
            }
        });
    }

    private String addDilution(String dilution, List list) {
        String[] items = list.getItems();
        if (!this.itemExistsInList(dilution, items)) {
            return dilution;
        }
        return null;
    }

    private boolean itemExistsInList(String dilution, String[] list) {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(dilution)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String[] parseString(String stringList) {
        DilutionListUtil dilutionListUtil = new DilutionListUtil();
        Object[] dilutions = dilutionListUtil.parseString(stringList);
        Arrays.sort(dilutions);
        return dilutions;
    }
}

