/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.internal.provider;

import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.chemclipse.support.preferences.SupportPreferences;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class CopyToClipboardProvider {
    private final String DELIMITER = "\t";
    private final String LINE_BREAK = "\n";

    public void copyToClipboard(Clipboard clipboard, ExtendedTableViewer extendedTableViewer) {
        StringBuilder builder = new StringBuilder();
        int[] columns = this.getColumns(extendedTableViewer);
        this.addHeader(extendedTableViewer, builder, columns);
        this.addContent(extendedTableViewer, builder, columns);
        this.addNoContentMessageOnDemand(builder);
        this.transferToClipboard(clipboard, builder.toString());
    }

    private int[] addHeader(ExtendedTableViewer extendedTableViewer, StringBuilder builder, int[] columns) {
        String[] titles = this.getTitles(extendedTableViewer);
        int[] nArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            int column = nArray[n2];
            builder.append(this.optimizeText(titles[column]));
            builder.append("\t");
            ++n2;
        }
        builder.append(OperatingSystemUtils.getLineDelimiter());
        return columns;
    }

    private void addContent(ExtendedTableViewer extendedTableViewer, StringBuilder builder, int[] columns) {
        Table table = extendedTableViewer.getTable();
        int[] nArray = table.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem selection = table.getItem(index);
            int[] nArray2 = columns;
            int n3 = columns.length;
            int n4 = 0;
            while (n4 < n3) {
                int column = nArray2[n4];
                builder.append(this.optimizeText(selection.getText(column)));
                builder.append("\t");
                ++n4;
            }
            builder.append(OperatingSystemUtils.getLineDelimiter());
            ++n2;
        }
    }

    private String optimizeText(String text) {
        return text.replaceAll("\n", " ");
    }

    private void addNoContentMessageOnDemand(StringBuilder builder) {
        if (builder.length() == 0) {
            builder.append("Please select one or more entries in the list.");
            builder.append(OperatingSystemUtils.getLineDelimiter());
        }
    }

    private void transferToClipboard(Clipboard clipboard, String content) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object[] data = new Object[]{content};
        Transfer[] dataTypes = new Transfer[]{textTransfer};
        clipboard.setContents(data, dataTypes);
    }

    private int[] getColumns(ExtendedTableViewer extendedTableViewer) {
        int[] columns;
        Table table = extendedTableViewer.getTable();
        boolean useDefaultSorting = SupportPreferences.isClipboardDefaultSorting();
        if (useDefaultSorting) {
            int size = extendedTableViewer.getTableViewerColumns().size();
            columns = IntStream.range(0, size).toArray();
        } else {
            columns = table.getColumnOrder();
        }
        return columns;
    }

    private String[] getTitles(ExtendedTableViewer extendedTableViewer) {
        List<TableViewerColumn> tableViewerColumns = extendedTableViewer.getTableViewerColumns();
        String[] titles = new String[tableViewerColumns.size()];
        int i = 0;
        for (TableViewerColumn tableViewerColumn : tableViewerColumns) {
            titles[i++] = tableViewerColumn.getColumn().getText();
        }
        return titles;
    }
}

