/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.settings.UserManagement;
import org.eclipse.chemclipse.support.ui.editors.IMultiEditorPage;
import org.eclipse.chemclipse.support.ui.editors.IReportEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class AbstractReportEditor
extends MultiPageEditorPart
implements IReportEditor {
    private static final Logger logger = Logger.getLogger(AbstractReportEditor.class);
    private String currentUser = UserManagement.getCurrentUser();
    private boolean isDirty = false;
    private List<IMultiEditorPage> pages = new ArrayList<IMultiEditorPage>();
    private String fileExtension;

    public AbstractReportEditor(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Override
    public String getCurrentUser() {
        return this.currentUser;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.firePropertyChange(257);
    }

    public void dispose() {
        for (IMultiEditorPage page : this.pages) {
            if (page == null) continue;
            page.dispose();
        }
        super.dispose();
    }

    @Override
    public String getFileName() {
        if (this.getInputFile() != null) {
            return this.getInputFile().getName();
        }
        return "NoFileAvailable";
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public void addEditorPage(IMultiEditorPage page) {
        this.pages.add(page);
        this.setPageText(page.getPageIndex(), page.getEditorTitle());
    }

    public void setFocus() {
        int activePageIndex = this.getActivePage();
        for (IMultiEditorPage page : this.pages) {
            if (page.getPageIndex() != activePageIndex) continue;
            logger.info((Object)("Page set focus: " + page.getEditorTitle()));
            page.setFocus();
            break;
        }
        super.setFocus();
    }

    @Override
    public void setActivePage(String editorId) {
        if (this.pages != null) {
            int pageIndex = -1;
            for (IMultiEditorPage page : this.pages) {
                if (!page.getEditorId().equals(editorId)) continue;
                pageIndex = page.getPageIndex();
                if (pageIndex < 0) break;
                logger.info((Object)("Set active page: " + page.getEditorTitle()));
                this.setActivePage(pageIndex);
                break;
            }
        }
    }

    protected IFile getInputFile() {
        IEditorInput editorInput = this.getEditorInput();
        IFile file = ((IFileEditorInput)editorInput).getFile();
        return file;
    }

    protected void refreshWorkspace(IFile file, IProgressMonitor monitor) {
        if (file != null) {
            try {
                file.refreshLocal(1, monitor);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
    }

    protected void updateStatusWidgets() {
        for (IMultiEditorPage page : this.pages) {
            page.updateWidgetStatus();
        }
    }
}

