/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.pcr.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.pcr.model.core.AbstractDataModel;
import org.eclipse.chemclipse.pcr.model.core.IChannel;
import org.eclipse.chemclipse.pcr.model.core.IChannelSpecification;
import org.eclipse.chemclipse.pcr.model.core.IDetectionFormat;
import org.eclipse.chemclipse.pcr.model.core.IWell;
import org.eclipse.chemclipse.pcr.model.core.Position;

public class Well
extends AbstractDataModel
implements IWell {
    private static final Logger logger = Logger.getLogger(Well.class);
    private static final String ALL_SUBSETS_SELECTED = "";
    private IChannel activeChannel = null;
    private String activeSubset = "";
    private Position position = new Position();
    private Map<Integer, IChannel> channels = new HashMap<Integer, IChannel>();

    public Well() {
        this.addProtectedKey("Sample ID");
        this.addProtectedKey("Target Name");
        this.addProtectedKey("Crossing Point");
        this.addProtectedKey("Sample Subset");
    }

    @Override
    public String getLabel() {
        if (this.isEmptyMeasurement()) {
            return "Position: " + (this.getPosition().getId() + 1);
        }
        return "Position: " + (this.getPosition().getId() + 1) + " | ID:" + this.getSampleId();
    }

    @Override
    public IChannel getActiveChannel() {
        return this.activeChannel;
    }

    @Override
    public void setActiveChannel(int activeChannel) {
        if (this.channels.keySet().contains(activeChannel)) {
            this.activeChannel = this.channels.get(activeChannel);
        }
    }

    @Override
    public void clearActiveChannel() {
        this.activeChannel = null;
    }

    @Override
    public boolean isActiveSubset() {
        if (ALL_SUBSETS_SELECTED.equals(this.activeSubset)) {
            return true;
        }
        return this.activeSubset.equals(this.getSampleSubset());
    }

    @Override
    public void setActiveSubset(String activeSubset) {
        this.activeSubset = activeSubset;
    }

    @Override
    public void clearActiveSubset() {
        this.activeSubset = ALL_SUBSETS_SELECTED;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Map<Integer, IChannel> getChannels() {
        return this.channels;
    }

    @Override
    public int compareTo(IWell well) {
        if (well != null) {
            return Integer.compare(this.position.getId(), well.getPosition().getId());
        }
        return 0;
    }

    @Override
    public String getSampleId() {
        return this.getData("Sample ID", ALL_SUBSETS_SELECTED).trim();
    }

    @Override
    public String getSampleSubset() {
        return this.getData("Sample Subset", ALL_SUBSETS_SELECTED).trim();
    }

    @Override
    public String getTargetName() {
        return this.getData("Target Name", ALL_SUBSETS_SELECTED).trim();
    }

    @Override
    public double getCrossingPoint() {
        String value = this.getData("Crossing Point", "0");
        double result = 0.0;
        try {
            result = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return result;
    }

    @Override
    public boolean isEmptyMeasurement() {
        return ALL_SUBSETS_SELECTED.equals(this.getSampleId().trim()) || "_".equals(this.getSampleId().trim());
    }

    @Override
    public boolean isPositiveMeasurement() {
        if (this.activeChannel == null) {
            for (IChannel channel : this.channels.values()) {
                if (!this.isChannelPositive(channel)) continue;
                return true;
            }
        } else {
            return this.isChannelPositive(this.activeChannel);
        }
        return false;
    }

    @Override
    public void applyDetectionFormat(IDetectionFormat detectionFormat) {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.channels.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            IChannel channel = this.channels.get(key);
            String detectionName = "Channel " + key;
            if (detectionFormat != null && key >= 0 && key < detectionFormat.getChannelSpecifications().size()) {
                IChannelSpecification channelSpecification = detectionFormat.getChannelSpecifications().get(key);
                detectionName = channelSpecification.getName();
            }
            channel.setDetectionName(detectionName);
        }
    }

    private boolean isChannelPositive(IChannel channel) {
        return channel != null && channel.getCrossingPoint() != null && channel.getCrossingPoint().getX() > 0.0;
    }
}

