/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.helper;

import java.io.File;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.settings.ApplicationSettings;

public class PathHelper {
    private static final Logger logger = Logger.getLogger(PathHelper.class);
    public static final String NIST_IDENTIFIER = "org.eclipse.chemclipse.msd.identifier.supplier.nist";

    public static File getStoragePath() {
        File file = new File(String.valueOf(ApplicationSettings.getSettingsDirectory().getAbsolutePath()) + File.separator + NIST_IDENTIFIER);
        if (!file.exists() && !file.mkdirs()) {
            logger.warn((Object)("The temporarily nist identifier directory could not be created: " + file.getAbsolutePath()));
        }
        return file;
    }

    public static void cleanStoragePath() {
        File directory = PathHelper.getStoragePath();
        PathHelper.deleteFiles(directory);
    }

    private static void deleteFiles(File directory) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                PathHelper.deleteFiles(file);
            } else if (!file.delete()) {
                logger.warn((Object)("The file " + file + "could not be deleted."));
            }
            ++n2;
        }
        if (!directory.delete()) {
            logger.warn((Object)("The directory " + directory + "could not be deleted."));
        }
    }
}

