/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.ui.dialogs.DialogSupport;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.ui.runnables.PeakListIdentifierGUIRunnable;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.ui.runnables.PeakListIdentifierRunnable;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class IdentifyAllPeaksHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(IdentifyAllPeaksHandler.class);
    private static IChromatogramSelectionMSD chromatogramSelection;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        if (chromatogramSelection != null) {
            Object runnable;
            Display display = Display.getCurrent();
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start the peak identification.");
            if (PreferenceSupplier.isUseGUIDirect()) {
                DialogSupport.showGUIDialog();
                runnable = new PeakListIdentifierGUIRunnable(chromatogramSelection);
            } else {
                runnable = new PeakListIdentifierRunnable(chromatogramSelection);
            }
            this.runOperation(display, (IRunnableWithProgress)runnable);
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: All Peaks identified");
        }
    }

    private void runOperation(Display display, IRunnableWithProgress runnable) {
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
        try {
            monitor.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }
}

