/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.database;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.converter.core.Converter;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverterSupport;
import org.eclipse.chemclipse.msd.converter.database.DatabaseSupplier;
import org.eclipse.chemclipse.msd.converter.database.IDatabaseExportConverter;
import org.eclipse.chemclipse.msd.converter.database.IDatabaseImportConverter;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class DatabaseConverter {
    private static final Logger logger = Logger.getLogger(DatabaseConverter.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.msd.converter.databaseSupplier";

    private DatabaseConverter() {
    }

    public static IProcessingInfo<IMassSpectra> convert(File file, String converterId, IProgressMonitor monitor) {
        IDatabaseImportConverter importConverter = DatabaseConverter.getDatabaseImportConverter(converterId);
        Object processingInfo = importConverter != null ? importConverter.convert(file, monitor) : DatabaseConverter.getNoImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IProcessingInfo<IMassSpectra> convert(File file, IProgressMonitor monitor) {
        return DatabaseConverter.getMassSpectra(file, monitor);
    }

    private static IProcessingInfo<IMassSpectra> getMassSpectra(File file, IProgressMonitor monitor) {
        Object processingInfo = new IProcessingInfo();
        DatabaseConverterSupport converterSupport = DatabaseConverter.getDatabaseConverterSupport();
        try {
            List availableConverterIds = converterSupport.getAvailableConverterIds(file);
            for (String converterId : availableConverterIds) {
                IDatabaseImportConverter importConverter = DatabaseConverter.getDatabaseImportConverter(converterId);
                if (importConverter == null || (processingInfo = importConverter.convert(file, monitor)).hasErrorMessages()) continue;
                return processingInfo;
            }
        }
        catch (NoConverterAvailableException e) {
            logger.info((Object)e);
            processingInfo = DatabaseConverter.getNoImportConverterAvailableProcessingInfo(file);
        }
        return processingInfo;
    }

    public static IProcessingInfo<File> convert(File file, IScanMSD massSpectrum, boolean append, String converterId, IProgressMonitor monitor) {
        IDatabaseExportConverter exportConverter = DatabaseConverter.getDatabaseExportConverter(converterId);
        Object processingInfo = exportConverter != null ? exportConverter.convert(file, massSpectrum, append, monitor) : DatabaseConverter.getNoExportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IProcessingInfo<File> convert(File file, IMassSpectra massSpectra, boolean append, String converterId, IProgressMonitor monitor) {
        IDatabaseExportConverter exportConverter = DatabaseConverter.getDatabaseExportConverter(converterId);
        Object processingInfo = exportConverter != null ? exportConverter.convert(file, massSpectra, append, monitor) : DatabaseConverter.getNoExportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    private static IDatabaseImportConverter getDatabaseImportConverter(String converterId) {
        IConfigurationElement element = DatabaseConverter.getConfigurationElement(converterId);
        IDatabaseImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IDatabaseImportConverter)element.createExecutableExtension("importConverter");
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    private static <T> IDatabaseExportConverter getDatabaseExportConverter(String converterId) {
        IConfigurationElement element = DatabaseConverter.getConfigurationElement(converterId);
        IDatabaseExportConverter instance = null;
        if (element != null) {
            try {
                instance = (IDatabaseExportConverter)element.createExecutableExtension("exportConverter");
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static DatabaseConverterSupport getDatabaseConverterSupport() {
        IConfigurationElement[] extensions;
        DatabaseConverterSupport databaseConverterSupport = new DatabaseConverterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            DatabaseSupplier supplier = new DatabaseSupplier();
            supplier.setFileExtension(element.getAttribute("fileExtension"));
            supplier.setFileName(element.getAttribute("fileName"));
            supplier.setDirectoryExtension(element.getAttribute("directoryExtension"));
            if (Converter.isValid((String)supplier.getFileExtension()) && Converter.isValid((String)supplier.getFileName()) && Converter.isValid((String)supplier.getDirectoryExtension())) {
                supplier.setId(element.getAttribute("id"));
                supplier.setDescription(element.getAttribute("description"));
                supplier.setFilterName(element.getAttribute("filterName"));
                supplier.setExportable(Boolean.valueOf(element.getAttribute("isExportable")));
                supplier.setImportable(Boolean.valueOf(element.getAttribute("isImportable")));
                supplier.setMagicNumberMatcher(DatabaseConverter.getMagicNumberMatcher(element));
                databaseConverterSupport.add(supplier);
            }
            ++n2;
        }
        return databaseConverterSupport;
    }

    private static IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension("importMagicNumberMatcher");
        }
        catch (Exception e) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }

    private static <T> IProcessingInfo<T> getNoExportConverterAvailableProcessingInfo(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, "Database Export Converter", "There is no suitable converter available to export the mass spectra to the file: " + file.getAbsolutePath());
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }

    private static <T> IProcessingInfo<T> getNoImportConverterAvailableProcessingInfo(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, "Database Import Converter", "There is no suitable converter available to load the mass spectra from the file: " + file.getAbsolutePath());
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

