/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.converter.io.AbstractMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.model.IVendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.model.VendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.core.runtime.IProgressMonitor;

public class MSPReader
extends AbstractMassSpectraReader
implements IMassSpectraReader {
    private static final Logger logger = Logger.getLogger(MSPReader.class);
    private static final String CONVERTER_ID = "org.eclipse.chemclipse.msd.converter.supplier.amdis.massspectrum.msp";
    private static final String LINE_END = "\n";
    private static final Pattern namePattern = Pattern.compile("(NAME:)(.*)", 2);
    private static final Pattern nameRetentionTimePattern = Pattern.compile("(rt:\\s*)(\\d+\\.?\\d*([eE][+-]?\\d+)?)(\\s*min)", 2);
    private static final Pattern formulaPattern = Pattern.compile("(FORMULA:)(.*)", 2);
    private static final Pattern molweightPattern = Pattern.compile("(MW:)(.*)", 2);
    private static final Pattern synonymPattern = Pattern.compile("(Synon:)(.*)", 2);
    private static final Pattern commentsPattern = Pattern.compile("(COMMENTS:)(.*)", 2);
    private static final Pattern commentPattern = Pattern.compile("(COMMENT:)(.*)", 2);
    private static final Pattern casNumberPattern = Pattern.compile("(CAS(NO|#)?:[ ]+)([0-9-]*)", 2);
    private static final Pattern databaseNamePattern = Pattern.compile("(DB(NO|#)?:)(.*)", 2);
    private static final Pattern referenceIdentifierPattern = Pattern.compile("(REFID:)(.*)", 2);
    private static final Pattern smilesPattern = Pattern.compile("(SMILES:)(.*)", 2);
    private static final Pattern retentionTimePattern = Pattern.compile("(RT:)(.*)", 2);
    private static final Pattern relativeRetentionTimePattern = Pattern.compile("(RRT:)(.*)", 2);
    private static final Pattern retentionIndexPattern = Pattern.compile("(RI:)(.*)", 2);
    private static final Pattern dataPattern = Pattern.compile("(.*)(Num Peaks:)(\\s*)(\\d*)(.*)", 42);
    private static final Pattern ionPattern = Pattern.compile("([+]?\\d+\\.?\\d*)([\t ,;:]+)([+-]?\\d+\\.?\\d*([eE][+-]?\\d+)?)");
    private static final String RETENTION_INDICES_DELIMITER = ", ";

    public IMassSpectra read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        List<String> massSpectraData = this.getMassSpectraData(file);
        IMassSpectra massSpectra = this.extractMassSpectra(massSpectraData);
        massSpectra.setConverterId(CONVERTER_ID);
        massSpectra.setName(file.getName());
        return massSpectra;
    }

    private List<String> getMassSpectraData(File file) throws IOException {
        String line;
        Charset charSet = Charset.forName("US-ASCII");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, charSet);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ArrayList<String> massSpectraData = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            if (line.length() == 0) {
                this.addMassSpectrumData(builder, massSpectraData);
                builder = new StringBuilder();
                continue;
            }
            builder.append(line);
            builder.append(LINE_END);
        }
        this.addMassSpectrumData(builder, massSpectraData);
        bufferedReader.close();
        inputStreamReader.close();
        bufferedInputStream.close();
        return massSpectraData;
    }

    private void addMassSpectrumData(StringBuilder builder, List<String> massSpectraData) {
        if (builder.length() > 0) {
            String massSpectrumData = builder.toString();
            massSpectraData.add(massSpectrumData);
        }
    }

    private IMassSpectra extractMassSpectra(List<String> massSpectraData) {
        MassSpectra massSpectra;
        block6: {
            String[] splittedMassSpectra;
            String referenceIdentifierPrefix;
            String referenceIdentifierMarker;
            block5: {
                massSpectra = new MassSpectra();
                referenceIdentifierMarker = PreferenceSupplier.getReferenceIdentifierMarker();
                referenceIdentifierPrefix = PreferenceSupplier.getReferenceIdentifierPrefix();
                if (massSpectraData.size() <= 1) break block5;
                for (String massSpectrumData : massSpectraData) {
                    this.addMassSpectrum((IMassSpectra)massSpectra, massSpectrumData, referenceIdentifierMarker, referenceIdentifierPrefix);
                }
                break block6;
            }
            if (massSpectraData.size() != 1) break block6;
            String[] stringArray = splittedMassSpectra = massSpectraData.get(0).split("(NAME:|name:)");
            int n = splittedMassSpectra.length;
            int n2 = 0;
            while (n2 < n) {
                String splittedMassSpectrum = stringArray[n2];
                if (!splittedMassSpectrum.equals("")) {
                    if (splittedMassSpectra.length == 1) {
                        this.addMassSpectrum((IMassSpectra)massSpectra, splittedMassSpectrum, referenceIdentifierMarker, referenceIdentifierPrefix);
                    } else {
                        this.addMassSpectrum((IMassSpectra)massSpectra, "NAME:" + splittedMassSpectrum, referenceIdentifierMarker, referenceIdentifierPrefix);
                    }
                }
                ++n2;
            }
        }
        return massSpectra;
    }

    private void addMassSpectrum(IMassSpectra massSpectra, String massSpectrumData, String referenceIdentifierMarker, String referenceIdentifierPrefix) {
        VendorLibraryMassSpectrum massSpectrum = new VendorLibraryMassSpectrum();
        ILibraryInformation libraryInformation = massSpectrum.getLibraryInformation();
        String name = this.extractContentAsString(massSpectrumData, namePattern, 2);
        this.extractNameAndReferenceIdentifier(massSpectrum, name, referenceIdentifierMarker, referenceIdentifierPrefix);
        String referenceIdentifier = this.extractContentAsString(massSpectrumData, referenceIdentifierPattern, 2);
        massSpectrum.getLibraryInformation().setReferenceIdentifier(referenceIdentifier);
        String formula = this.extractContentAsString(massSpectrumData, formulaPattern, 2);
        libraryInformation.setFormula(formula);
        double molWeight = this.extractContentAsDouble(massSpectrumData, molweightPattern);
        libraryInformation.setMolWeight(molWeight);
        Set<String> synonyms = this.extractSynonyms(massSpectrumData, synonymPattern);
        massSpectrum.getLibraryInformation().setSynonyms(synonyms);
        String comments = this.extractContentAsString(massSpectrumData, commentsPattern, 2);
        String comment = this.extractContentAsString(massSpectrumData, commentPattern, 2);
        String commentData = String.valueOf(comments) + comment;
        libraryInformation.setComments(commentData.trim());
        String casNumber = this.extractContentAsString(massSpectrumData, casNumberPattern, 3);
        libraryInformation.setCasNumber(casNumber);
        String database = this.extractContentAsString(massSpectrumData, databaseNamePattern, 3);
        libraryInformation.setDatabase(database);
        String smiles = this.extractContentAsString(massSpectrumData, smilesPattern, 2);
        libraryInformation.setSmiles(smiles);
        int retentionTime = this.extractContentAsInt(massSpectrumData, retentionTimePattern, 2);
        if (retentionTime == 0) {
            retentionTime = this.extractContentAsInt(massSpectrumData, nameRetentionTimePattern, 2);
        }
        massSpectrum.setRetentionTime(retentionTime);
        int relativeRetentionTime = this.extractContentAsInt(massSpectrumData, relativeRetentionTimePattern, 2);
        massSpectrum.setRelativeRetentionTime(relativeRetentionTime);
        String retentionIndices = this.extractContentAsString(massSpectrumData, retentionIndexPattern, 2);
        this.extractRetentionIndices(massSpectrum, retentionIndices, RETENTION_INDICES_DELIMITER);
        this.extractIons(massSpectrum, massSpectrumData);
        if (massSpectrum.getNumberOfIons() > 0) {
            massSpectra.addMassSpectrum((IScanMSD)massSpectrum);
        }
    }

    private void extractIons(IVendorLibraryMassSpectrum massSpectrum, String massSpectrumData) {
        String ionData = "";
        Matcher data = dataPattern.matcher(massSpectrumData);
        data.find();
        if (data.matches()) {
            ionData = data.group(5);
        }
        Ion amdisIon = null;
        Matcher ions = ionPattern.matcher(ionData);
        while (ions.find()) {
            try {
                double ion = Double.parseDouble(ions.group(1));
                float abundance = Float.parseFloat(ions.group(3));
                if (!(abundance > 0.0f)) continue;
                amdisIon = new Ion(ion, abundance);
                massSpectrum.addIon((IIon)amdisIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
    }

    private String extractContentAsString(String massSpectrumData, Pattern pattern, int group) {
        String content = "";
        Matcher matcher = pattern.matcher(massSpectrumData);
        if (matcher.find()) {
            content = matcher.group(group).trim();
        }
        return content;
    }

    private Set<String> extractSynonyms(String massSpectrumData, Pattern pattern) {
        HashSet<String> synonyms = new HashSet<String>();
        Matcher matcher = pattern.matcher(massSpectrumData);
        while (matcher.find()) {
            String synonym = matcher.group(2).trim();
            synonyms.add(synonym);
        }
        return synonyms;
    }

    private int extractContentAsInt(String massSpectrumData, Pattern pattern, int group) {
        int content = 0;
        try {
            Matcher matcher = pattern.matcher(massSpectrumData);
            if (matcher.find()) {
                content = (int)(Double.parseDouble(matcher.group(group).trim()) * 60000.0);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        return content;
    }

    private double extractContentAsDouble(String massSpectrumData, Pattern pattern) {
        double content = 0.0;
        try {
            Matcher matcher = pattern.matcher(massSpectrumData);
            if (matcher.find()) {
                content = Double.parseDouble(matcher.group(2));
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        return content;
    }
}

