/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraWriter;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.AbstractMassSpectraWriter;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class MSLWriter
extends AbstractMassSpectraWriter
implements IMassSpectraWriter {
    public void writeMassSpectrum(FileWriter fileWriter, IScanMSD massSpectrum, IProgressMonitor monitor) throws IOException {
        IScanMSD optimizedMassSpectrum = this.getOptimizedMassSpectrum(massSpectrum);
        IIdentificationTarget identificationTarget = this.getIdentificationTarget(optimizedMassSpectrum);
        if (identificationTarget == null) {
            identificationTarget = this.getIdentificationTarget(massSpectrum);
        } else if ("".equals(identificationTarget.getLibraryInformation().getName())) {
            identificationTarget = this.getIdentificationTarget(massSpectrum);
        }
        fileWriter.write(String.valueOf(this.getNameField(massSpectrum, identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getCasNumberField(identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getSmilesField(identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getRetentionTimeField(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write(String.valueOf(this.getRelativeRetentionTimeField(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write(String.valueOf(this.getRetentionIndexField(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write(String.valueOf(this.getDBField(identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getReferenceIdentifierField(identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getCommentsField(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write(String.valueOf(this.getSourceField(optimizedMassSpectrum, identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getNumberOfPeaks(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write(String.valueOf(this.getIonsFormatMSL(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write("\r\n");
        fileWriter.flush();
    }
}

