/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.eclipse.chemclipse.model.exceptions.InvalidHeaderModificationException;
import org.eclipse.chemclipse.model.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.support.text.ValueFormat;

public interface IMeasurementInfo
extends Serializable {
    public static final String OPERATOR = "Operator";
    public static final String DATE = "Date";
    public static final String MISC_INFO = "Misc Info";
    public static final String MISC_INFO_SEPARATED = "Misc Info Separated";
    public static final String SHORT_INFO = "Short Info";
    public static final String DETAILED_INFO = "Detailed Info";
    public static final String SAMPLE_GROUP = "Sample Group";
    public static final String BARCODE = "Barcode";
    public static final String BARCODE_TYPE = "Barcode Type";
    public static final String SAMPLE_WEIGHT = "Sample Weight";
    public static final String SAMPLE_WEIGHT_UNIT = "Sample Weight Unit";
    public static final String DATA_NAME = "Data Name";
    public static final String X_UNIT_NAME = "X Axis Unit";
    public static final String Y_UNIT_NAME = "Y Axis Unit";
    public static final String X_AXIS_TITLE = "X Axis Title";
    public static final String Y_AXIS_TITLE = "Y Axis Title";

    default public String getHeaderData(String key) {
        return this.getHeaderDataMap().get(key);
    }

    default public String getHeaderDataOrDefault(String key, String defaultValue) {
        String data = this.getHeaderData(key);
        if (data == null || data.isEmpty()) {
            return defaultValue;
        }
        return data;
    }

    default public boolean headerDataContainsKey(String key) {
        return this.getHeaderDataMap().containsKey(key);
    }

    public void putHeaderData(String var1, String var2);

    public void removeHeaderData(String var1) throws InvalidHeaderModificationException;

    public Map<String, String> getHeaderDataMap();

    default public String getOperator() {
        return this.getHeaderData(OPERATOR);
    }

    default public void setOperator(String operator) {
        this.putHeaderData(OPERATOR, operator);
    }

    default public Date getDate() {
        try {
            return ValueFormat.getDateFormatEnglish((String)"yyyy/MM/dd HH:mm:ss").parse(this.getHeaderData(DATE));
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    default public void setDate(Date date) {
        if (date != null) {
            this.putHeaderData(DATE, ValueFormat.getDateFormatEnglish((String)"yyyy/MM/dd HH:mm:ss").format(date));
        } else {
            this.putHeaderData(DATE, "");
        }
    }

    default public String getMiscInfo() {
        return this.getHeaderData(MISC_INFO);
    }

    default public void setMiscInfo(String miscInfo) {
        if (miscInfo != null) {
            String[] values = miscInfo.split(PreferenceSupplier.getMiscSeparator());
            if (values.length >= 2) {
                this.putHeaderData(MISC_INFO, values[0]);
                StringBuilder builder = new StringBuilder();
                int i = 1;
                while (i < values.length) {
                    builder.append(values[i].trim());
                    builder.append(PreferenceSupplier.getMiscSeparatedDelimiter());
                    ++i;
                }
                this.putHeaderData(MISC_INFO_SEPARATED, builder.toString().trim());
            } else {
                this.putHeaderData(MISC_INFO, miscInfo);
            }
        } else {
            this.putHeaderData(MISC_INFO, "");
            this.putHeaderData(MISC_INFO_SEPARATED, "");
        }
    }

    default public String getMiscInfoSeparated() {
        return this.getHeaderData(MISC_INFO_SEPARATED);
    }

    default public void setMiscInfoSeparated(String miscInfoSeparated) {
        this.putHeaderData(MISC_INFO_SEPARATED, miscInfoSeparated);
    }

    default public String getShortInfo() {
        return this.getHeaderData(SHORT_INFO);
    }

    default public void setShortInfo(String shortInfo) {
        if (shortInfo != null) {
            this.putHeaderData(SHORT_INFO, shortInfo);
        } else {
            this.putHeaderData(SHORT_INFO, "");
        }
    }

    default public String getDetailedInfo() {
        return this.getHeaderData(DETAILED_INFO);
    }

    default public void setDetailedInfo(String detailedInfo) {
        if (detailedInfo != null) {
            this.putHeaderData(DETAILED_INFO, detailedInfo);
        } else {
            this.putHeaderData(DETAILED_INFO, "");
        }
    }

    default public String getSampleGroup() {
        return this.getHeaderData(SAMPLE_GROUP);
    }

    default public void setSampleGroup(String sampleGroup) {
        if (sampleGroup != null) {
            this.putHeaderData(SAMPLE_GROUP, sampleGroup);
        } else {
            this.putHeaderData(SAMPLE_GROUP, "");
        }
    }

    default public String getBarcode() {
        return this.getHeaderData(BARCODE);
    }

    default public void setBarcode(String barcode) {
        if (barcode != null) {
            this.putHeaderData(BARCODE, barcode);
        } else {
            this.putHeaderData(BARCODE, "");
        }
    }

    default public String getBarcodeType() {
        return this.getHeaderData(BARCODE_TYPE);
    }

    default public void setBarcodeType(String barcodeType) {
        if (barcodeType != null) {
            this.putHeaderData(BARCODE_TYPE, barcodeType);
        } else {
            this.putHeaderData(BARCODE_TYPE, "");
        }
    }

    default public double getSampleWeight() {
        try {
            return Double.parseDouble(this.getHeaderData(SAMPLE_WEIGHT));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    default public void setSampleWeight(double sampleWeight) {
        if (sampleWeight >= 0.0) {
            this.putHeaderData(SAMPLE_WEIGHT, Double.valueOf(sampleWeight).toString());
        } else {
            this.putHeaderData(SAMPLE_WEIGHT, Double.valueOf(0.0).toString());
        }
    }

    default public String getSampleWeightUnit() {
        return this.getHeaderData(SAMPLE_WEIGHT_UNIT);
    }

    default public void setSampleWeightUnit(String sampleWeightUnit) {
        if (sampleWeightUnit != null) {
            this.putHeaderData(SAMPLE_WEIGHT_UNIT, sampleWeightUnit);
        } else {
            this.putHeaderData(SAMPLE_WEIGHT_UNIT, "");
        }
    }

    default public String getDataName() {
        return this.getHeaderData(DATA_NAME);
    }

    default public void setDataName(String dataName) {
        if (dataName != null) {
            this.putHeaderData(DATA_NAME, dataName);
        } else {
            this.putHeaderData(DATA_NAME, "");
        }
    }
}

