/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;

public interface IChromatogramPeaks<T extends IPeak> {
    public void removeAllPeaks();

    public int getNumberOfPeaks();

    public void addPeak(T var1);

    public void removePeak(T var1);

    public void removePeaks(List<T> var1);

    public List<T> getPeaks(int var1, int var2);

    public List<T> getPeaks();

    default public List<T> getPeaks(IRetentionTimeRange range) {
        if (range == null) {
            return this.getPeaks();
        }
        return this.getPeaks(range.getStartRetentionTime(), range.getStopRetentionTime());
    }

    default public IPeaks<T> toPeaks(final String name) {
        return new IPeaks<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public List<T> getPeaks() {
                return Collections.unmodifiableList(IChromatogramPeaks.this.getPeaks());
            }
        };
    }

    default public IPeaks<T> toPeaks(final String name, final IRetentionTimeRange range) {
        return new IPeaks<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public List<T> getPeaks() {
                return Collections.unmodifiableList(IChromatogramPeaks.this.getPeaks(range));
            }
        };
    }
}

