/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.logging.ui.support;

import java.io.IOException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.chemclipse.logging.ui.Activator;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleAppender
extends AppenderSkeleton {
    protected IConsoleManager consoleManager;
    protected String symbolicName;
    protected String logLevel = "ERROR";

    protected void append(LoggingEvent arg0) {
        if (this.consoleManager == null) {
            this.consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            this.symbolicName = Activator.getDefault().getBundle().getSymbolicName();
        }
        if (this.layout == null) {
            return;
        }
        StringBuffer message = new StringBuffer();
        message.append(this.layout.format(arg0));
        Level level = arg0.getLevel();
        if (level.toInt() >= Level.toLevel((String)this.logLevel).toInt()) {
            IConsole[] existing = this.consoleManager.getConsoles();
            int i = 0;
            while (i < existing.length) {
                MessageConsoleStream stream = ((MessageConsole)existing[i]).newMessageStream();
                try {
                    stream.write(message.toString().getBytes());
                    stream.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public void close() {
        this.consoleManager = null;
        this.symbolicName = null;
    }

    public boolean requiresLayout() {
        return true;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }
}

