/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.support.util.FileUtil;

public class Converter {
    public static final String ID = "id";
    public static final String DESCRIPTION = "description";
    public static final String FILTER_NAME = "filterName";
    public static final String FILE_EXTENSION = "fileExtension";
    public static final String FILE_NAME = "fileName";
    public static final String DIRECTORY_EXTENSION = "directoryExtension";
    public static final String IS_EXPORTABLE = "isExportable";
    public static final String IS_IMPORTABLE = "isImportable";
    public static final String EXPORT_CONVERTER = "exportConverter";
    public static final String IMPORT_CONVERTER = "importConverter";
    public static final String IMPORT_MAGIC_NUMBER_MATCHER = "importMagicNumberMatcher";

    private Converter() {
    }

    public static boolean isValid(String input) {
        if (input == null) {
            return false;
        }
        String regex = "[\\\\/:*?\"<>|]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        return !matcher.find();
    }

    public static String getExtensionMatcher(String supplierExtension) {
        String extensionMatcher = supplierExtension.replaceAll("#", "[0-9]");
        return extensionMatcher.replace(".", ".*\\.");
    }

    public static List<ISupplier> getSupplierForFile(File file, Iterable<? extends ISupplier> suppliers) throws NoConverterAvailableException {
        HashMap<String, String> regularExpressions = new HashMap<String, String>();
        ArrayList<ISupplier> availableConverters = new ArrayList<ISupplier>();
        String fileName = file.getName();
        for (ISupplier iSupplier : suppliers) {
            if (file.isDirectory()) {
                String[] directoryParts;
                String directoryExtension = iSupplier.getDirectoryExtension();
                if (fileName.endsWith(directoryExtension) || fileName.endsWith(directoryExtension.toLowerCase()) || fileName.endsWith(directoryExtension.toUpperCase())) {
                    availableConverters.add(iSupplier);
                    continue;
                }
                if (!directoryExtension.contains("#")) continue;
                if (directoryExtension.startsWith(".")) {
                    directoryExtension = directoryExtension.substring(1, directoryExtension.length());
                }
                if ((directoryParts = directoryExtension.split("#")).length <= 0 || !file.getName().matches(directoryParts[0])) continue;
                availableConverters.add(iSupplier);
                continue;
            }
            if (FileUtil.fileHasExtension((File)file)) {
                String fileExtension = iSupplier.getFileExtension();
                if (fileExtension == null || fileExtension.equals("")) continue;
                if (fileExtension.contains("#")) {
                    String supplierExtension = fileExtension.toLowerCase();
                    String extensionMatcher = (String)regularExpressions.get(supplierExtension);
                    if (extensionMatcher == null) {
                        extensionMatcher = Converter.getExtensionMatcher(supplierExtension);
                        regularExpressions.put(supplierExtension, extensionMatcher);
                    }
                    if (!fileName.toLowerCase().matches(extensionMatcher)) continue;
                    availableConverters.add(iSupplier);
                    continue;
                }
                if (!fileName.endsWith(fileExtension) && !fileName.endsWith(fileExtension.toLowerCase()) && !fileName.endsWith(fileExtension.toUpperCase())) continue;
                availableConverters.add(iSupplier);
                continue;
            }
            String supplierFileName = iSupplier.getFileName().toLowerCase();
            if (supplierFileName == null || supplierFileName.equals("") || !fileName.endsWith(supplierFileName) && !fileName.endsWith(supplierFileName.toLowerCase()) && !fileName.endsWith(supplierFileName.toUpperCase())) continue;
            availableConverters.add(iSupplier);
        }
        if (availableConverters.isEmpty()) {
            throw new NoConverterAvailableException("There is no converter available to process the file: " + file.toString());
        }
        return availableConverters;
    }
}

