/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.ui.export.wizards;

import org.eclipse.chemclipse.chromatogram.xxd.report.model.IChromatogramReportSupplierEntry;
import org.eclipse.chemclipse.chromatogram.xxd.report.support.ReportSupplierTypeSupport;
import org.eclipse.chemclipse.chromatogram.xxd.report.ui.internal.wizards.ChromatogramReportEntriesWizard;
import org.eclipse.chemclipse.chromatogram.xxd.report.ui.internal.wizards.ProcessWizardDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ReportSupplierSelectionWizardPage
extends WizardPage {
    private Table reportSupplierTable;
    boolean appendReports = false;

    public ReportSupplierSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        container.setLayout((Layout)layout);
        GridData layoutData = new GridData(1796);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.createReportSelection(container, layoutData);
        this.setControl((Control)container);
    }

    public Table getTable() {
        return this.reportSupplierTable;
    }

    private void createReportSelection(Composite parent, GridData layoutData) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)layoutData);
        this.createTable(client);
        this.createButtons(client);
    }

    private void createTable(Composite parent) {
        this.reportSupplierTable = new Table(parent, 2);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.widthHint = 100;
        gridData.verticalSpan = 3;
        this.reportSupplierTable.setLayoutData((Object)gridData);
        this.reportSupplierTable.setHeaderVisible(true);
        this.reportSupplierTable.setLinesVisible(true);
        String[] titles = new String[]{"Report Name", "Report Folder/Report File", "Report Id"};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.reportSupplierTable, 0);
            column.setText(titles[i]);
            ++i;
        }
        i = 0;
        while (i < titles.length) {
            this.reportSupplierTable.getColumn(i).pack();
            ++i;
        }
        this.checkReportSupplier();
    }

    private void createButtons(Composite parent) {
        this.createAddButton(parent);
        this.createRemoveButton(parent);
        this.createRemoveAllButton(parent);
    }

    private void createAddButton(Composite parent) {
        Button buttonAdd = new Button(parent, 8);
        buttonAdd.setText("Add");
        buttonAdd.setLayoutData((Object)new GridData(258));
        buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Shell shell = Display.getCurrent().getActiveShell();
                ChromatogramReportEntriesWizard reportEntriesWizard = new ChromatogramReportEntriesWizard();
                ProcessWizardDialog wizardDialog = new ProcessWizardDialog(shell, (IWizard)reportEntriesWizard);
                wizardDialog.create();
                int returnCode = wizardDialog.open();
                if (returnCode == 0) {
                    IChromatogramReportSupplierEntry reportEntry = reportEntriesWizard.getChromatogramReportEntry();
                    if (reportEntry != null) {
                        ReportSupplierTypeSupport reportSupplierTypeSupport = new ReportSupplierTypeSupport();
                        TableItem item = new TableItem(ReportSupplierSelectionWizardPage.this.reportSupplierTable, 0);
                        item.setText(0, reportSupplierTypeSupport.getReportName(reportEntry));
                        item.setText(1, reportEntry.getReportFolderOrFile());
                        item.setText(2, reportEntry.getReportSupplierId());
                    } else {
                        MessageBox messageBox = new MessageBox(shell);
                        messageBox.setText("Error Add Report Entry");
                        messageBox.setMessage("Please select a valid chromatogram report supplier and output folder.");
                        messageBox.open();
                    }
                }
                ReportSupplierSelectionWizardPage.this.checkReportSupplier();
            }
        });
    }

    private void createRemoveButton(Composite parent) {
        Button buttonRemove = new Button(parent, 8);
        buttonRemove.setText("Remove");
        buttonRemove.setLayoutData((Object)new GridData(258));
        buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ReportSupplierSelectionWizardPage.this.removeEntries(ReportSupplierSelectionWizardPage.this.reportSupplierTable.getSelectionIndices());
                ReportSupplierSelectionWizardPage.this.checkReportSupplier();
            }
        });
    }

    private void createRemoveAllButton(Composite parent) {
        Button remove = new Button(parent, 8);
        remove.setText("Remove All");
        remove.setLayoutData((Object)new GridData(258));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ReportSupplierSelectionWizardPage.this.reportSupplierTable.removeAll();
                ReportSupplierSelectionWizardPage.this.checkReportSupplier();
            }
        });
    }

    private void removeEntries(int[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        this.reportSupplierTable.remove(indices);
    }

    private void checkReportSupplier() {
        int count = this.reportSupplierTable.getItemCount();
        if (count > 0) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage("Please select at least one report provider.");
            this.setPageComplete(false);
        }
    }
}

