/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.settings.ReportSettings2;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReportWriter2 {
    private static final String DELIMITER = "\t";
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0000");
    private DateFormat dateFormat = ValueFormat.getDateFormatEnglish();
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);

    public void generate(File file, boolean append, List<IChromatogram<? extends IPeak>> chromatograms, ReportSettings2 reportSettings, IProgressMonitor monitor) throws IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        for (IChromatogram<? extends IPeak> chromatogram : chromatograms) {
            this.printHeader(printWriter, chromatogram);
            printWriter.println("");
            this.printAreaPercentList(printWriter, chromatogram, reportSettings);
            printWriter.println("");
        }
        printWriter.flush();
        fileWriter.flush();
        printWriter.close();
        fileWriter.close();
    }

    private void printHeader(PrintWriter printWriter, IChromatogram<? extends IPeak> chromatogram) {
        printWriter.println("File Name: " + chromatogram.getName());
        printWriter.println("Sample Name: " + chromatogram.getDataName());
        printWriter.println("Additional Info: " + chromatogram.getDetailedInfo() + " " + chromatogram.getMiscInfo());
        printWriter.println("Acquisition Date: " + this.dateFormat.format(chromatogram.getDate()));
        printWriter.println("Operator: " + chromatogram.getOperator());
        printWriter.println("Miscellaneous: " + chromatogram.getMiscInfo());
    }

    private void printAreaPercentList(PrintWriter printWriter, IChromatogram<? extends IPeak> chromatogramSource, ReportSettings2 reportSettings) {
        double[] chromatogramAreaSumArray = this.getChromatogramAreaSumArray(chromatogramSource);
        double[] peakAreaSumArray = this.initializePeakAreaSumArray(chromatogramSource);
        printWriter.print("Name");
        printWriter.print(DELIMITER);
        printWriter.print("Contributor");
        printWriter.print(DELIMITER);
        printWriter.print("Library Reference");
        printWriter.print(DELIMITER);
        printWriter.print("TIC%");
        printWriter.print(DELIMITER);
        this.printAreaPercentHeadlines(printWriter, chromatogramSource);
        printWriter.print("RI Library");
        printWriter.print(DELIMITER);
        printWriter.print("RI DA");
        printWriter.print(DELIMITER);
        printWriter.print("Scan#");
        printWriter.print(DELIMITER);
        printWriter.print("Retention Time (Minutes)");
        printWriter.print(DELIMITER);
        printWriter.print("Purity");
        printWriter.println("");
        for (IPeak peakSource : chromatogramSource.getPeaks()) {
            ILibraryInformation libraryInformationSource;
            IPeakModel peakModelSource = peakSource.getPeakModel();
            int retentionTime = peakModelSource.getRetentionTimeAtPeakMaximum();
            Set peakTargetsSource = peakSource.getTargets();
            if (peakTargetsSource.size() <= 0 || (libraryInformationSource = IIdentificationTarget.getBestLibraryInformation((Set)peakTargetsSource, (Comparator)this.targetExtendedComparator)) == null) continue;
            printWriter.print(libraryInformationSource != null ? libraryInformationSource.getName() : "");
            printWriter.print(DELIMITER);
            printWriter.print(libraryInformationSource != null ? libraryInformationSource.getContributor() : "");
            printWriter.print(DELIMITER);
            printWriter.print(libraryInformationSource != null ? libraryInformationSource.getReferenceIdentifier() : "");
            printWriter.print(DELIMITER);
            peakAreaSumArray = this.printAreaPercentData(printWriter, chromatogramSource, peakSource, libraryInformationSource, peakAreaSumArray, reportSettings);
            printWriter.print(this.decimalFormat.format(libraryInformationSource.getRetentionIndex()));
            printWriter.print(DELIMITER);
            printWriter.print(this.getRetentionIndex(peakModelSource));
            printWriter.print(DELIMITER);
            printWriter.print(chromatogramSource.getScanNumber(retentionTime));
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format((double)retentionTime / 60000.0));
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(this.getPurity(peakSource)));
            printWriter.println("");
        }
        printWriter.println("");
        printWriter.print("SUM");
        printWriter.print(DELIMITER);
        printWriter.print("");
        printWriter.print(DELIMITER);
        printWriter.print("");
        printWriter.print(DELIMITER);
        this.printAreaPercentSum(printWriter, chromatogramAreaSumArray, peakAreaSumArray);
        printWriter.print("");
        printWriter.print(DELIMITER);
        printWriter.print("");
        printWriter.print(DELIMITER);
        printWriter.print("");
        printWriter.print(DELIMITER);
        printWriter.print("");
        printWriter.print(DELIMITER);
        printWriter.print("");
        printWriter.println("");
    }

    private void printAreaPercentHeadlines(PrintWriter printWriter, IChromatogram chromatogramSource) {
        List referencedChromatograms = chromatogramSource.getReferencedChromatograms();
        int i = 1;
        for (IChromatogram referencedChromatogram : referencedChromatograms) {
            String label = referencedChromatogram instanceof IChromatogramMSD ? "MSD" + i + "%" : (referencedChromatogram instanceof IChromatogramCSD ? "CSD" + i + "%" : (referencedChromatogram instanceof IChromatogramWSD ? "WSD" + i + "%" : "???" + i + "%"));
            printWriter.print(label);
            printWriter.print(DELIMITER);
            ++i;
        }
    }

    private double[] printAreaPercentData(PrintWriter printWriter, IChromatogram chromatogramSource, IPeak peakSource, ILibraryInformation libraryInformationSource, double[] peakAreaSumArray, ReportSettings2 reportSettings) {
        List referencedChromatograms = chromatogramSource.getReferencedChromatograms();
        peakAreaSumArray[0] = peakAreaSumArray[0] + peakSource.getIntegratedArea();
        printWriter.print(this.decimalFormat.format(this.getPercentagePeakArea(chromatogramSource, peakSource)));
        printWriter.print(DELIMITER);
        int i = 1;
        for (IChromatogram referencedChromatogram : referencedChromatograms) {
            IPeak referencedPeak = this.getReferencedPeak(peakSource, libraryInformationSource, (IChromatogram<? extends IPeak>)referencedChromatogram, reportSettings);
            double peakArea = referencedPeak != null ? referencedPeak.getIntegratedArea() : 0.0;
            int n = i++;
            peakAreaSumArray[n] = peakAreaSumArray[n] + peakArea;
            printWriter.print(this.decimalFormat.format(this.getPercentagePeakArea(referencedChromatogram, referencedPeak)));
            printWriter.print(DELIMITER);
        }
        return peakAreaSumArray;
    }

    private void printAreaPercentSum(PrintWriter printWriter, double[] chromatogramAreaSumArray, double[] peakAreaSumArray) {
        if (chromatogramAreaSumArray.length == peakAreaSumArray.length) {
            int size = chromatogramAreaSumArray.length;
            int i = 0;
            while (i < size) {
                printWriter.print(this.decimalFormat.format(this.getPercentagePeakArea(chromatogramAreaSumArray[i], peakAreaSumArray[i])));
                printWriter.print(DELIMITER);
                ++i;
            }
        }
    }

    private double[] getChromatogramAreaSumArray(IChromatogram chromatogram) {
        List referencedChromatograms = chromatogram.getReferencedChromatograms();
        int size = 1 + referencedChromatograms.size();
        double[] chromatogramAreaSumArray = new double[size];
        chromatogramAreaSumArray[0] = chromatogram.getPeakIntegratedArea();
        int i = 1;
        for (IChromatogram referencedChromatogram : referencedChromatograms) {
            chromatogramAreaSumArray[i++] = referencedChromatogram.getPeakIntegratedArea();
        }
        return chromatogramAreaSumArray;
    }

    private double[] initializePeakAreaSumArray(IChromatogram chromatogram) {
        List referencedChromatograms = chromatogram.getReferencedChromatograms();
        int size = 1 + referencedChromatograms.size();
        return new double[size];
    }

    private IPeak getReferencedPeak(IPeak peakSource, ILibraryInformation libraryInformationSource, IChromatogram<? extends IPeak> referencedChromatogram, ReportSettings2 reportSettings) {
        if (peakSource != null && libraryInformationSource != null && referencedChromatogram != null) {
            IPeakModel peakModelSource = peakSource.getPeakModel();
            int retentionTimeSource = peakModelSource.getRetentionTimeAtPeakMaximum();
            int startRetentionTime = peakModelSource.getStartRetentionTime() - (int)(reportSettings.getDeltaRetentionTimeMinutesLeft() * 60000.0);
            int stopRetentionTime = peakModelSource.getStopRetentionTime() - (int)(reportSettings.getDeltaRetentionTimeMinutesRight() * 60000.0);
            boolean useBestMatch = reportSettings.isUseBestMatch();
            List<IPeak> peaksOfInterest = this.extractPeaksOfInterest(referencedChromatogram, startRetentionTime, stopRetentionTime);
            if (peaksOfInterest.size() > 0) {
                return this.extractBestMatchingPeak(peaksOfInterest, retentionTimeSource, libraryInformationSource, useBestMatch);
            }
        }
        return null;
    }

    private IPeak extractBestMatchingPeak(List<IPeak> peaksOfInterest, int retentionTimeSource, ILibraryInformation libraryInformationSource, boolean useBestMatch) {
        if (useBestMatch) {
            return this.getClosestPeak(peaksOfInterest, retentionTimeSource);
        }
        return this.getBestPeak(peaksOfInterest, libraryInformationSource, retentionTimeSource);
    }

    private IPeak getClosestPeak(List<IPeak> peaksOfInterest, int retentionTimeSource) {
        IPeak peakTarget = null;
        for (IPeak peakReference : peaksOfInterest) {
            peakTarget = this.getClosestPeak(peakTarget, peakReference, retentionTimeSource);
        }
        return peakTarget;
    }

    private IPeak getBestPeak(List<IPeak> peaksOfInterest, ILibraryInformation libraryInformationSource, int retentionTimeSource) {
        IPeak peakTarget = null;
        for (IPeak peakReference : peaksOfInterest) {
            if (peakTarget == null) {
                if (!this.isPeakTargetMatch(peakReference, libraryInformationSource)) continue;
                peakTarget = peakReference;
                continue;
            }
            IPeak peakClosest = this.getClosestPeak(peakTarget, peakReference, retentionTimeSource);
            if (peakClosest == peakTarget || !this.isPeakTargetMatch(peakClosest, libraryInformationSource)) continue;
            peakTarget = peakClosest;
        }
        return peakTarget;
    }

    private boolean isPeakTargetMatch(IPeak peak, ILibraryInformation libraryInformationSource) {
        for (IIdentificationTarget peakTarget : peak.getTargets()) {
            if (!this.isPeakTargetMatch(libraryInformationSource, peakTarget.getLibraryInformation())) continue;
            return true;
        }
        return false;
    }

    private IPeak getClosestPeak(IPeak peakTarget, IPeak peakReference, int retentionTimeSource) {
        int deltaTarget;
        if (peakTarget == null) {
            return peakReference;
        }
        int retentionTimeReference = peakReference.getPeakModel().getRetentionTimeAtPeakMaximum();
        int retentionTimeTarget = peakTarget.getPeakModel().getRetentionTimeAtPeakMaximum();
        int deltaReference = Math.abs(retentionTimeSource - retentionTimeReference);
        if (deltaReference < (deltaTarget = Math.abs(retentionTimeSource - retentionTimeTarget))) {
            return peakReference;
        }
        return peakTarget;
    }

    private List<IPeak> extractPeaksOfInterest(IChromatogram<? extends IPeak> referencedChromatogram, int startRetentionTime, int stopRetentionTime) {
        ArrayList<IPeak> peaksOfInterest = new ArrayList<IPeak>();
        for (IPeak peak : referencedChromatogram.getPeaks()) {
            int retentionTime = peak.getPeakModel().getRetentionTimeAtPeakMaximum();
            if (retentionTime < startRetentionTime || retentionTime > stopRetentionTime) continue;
            peaksOfInterest.add(peak);
        }
        return peaksOfInterest;
    }

    private boolean isPeakTargetMatch(ILibraryInformation libraryInformation, ILibraryInformation referencedLibraryInformation) {
        return libraryInformation != null && referencedLibraryInformation != null && libraryInformation.getName().equals(referencedLibraryInformation.getName());
    }

    private float getPurity(IPeak peak) {
        float purity = 1.0f;
        if (peak instanceof IChromatogramPeakMSD) {
            IChromatogramPeakMSD peakMSD = (IChromatogramPeakMSD)peak;
            purity = peakMSD.getPurity();
        } else if (peak instanceof IChromatogramPeakMSD) {
            IChromatogramPeakWSD peakWSD = (IChromatogramPeakWSD)peak;
            purity = peakWSD.getPurity();
        }
        return purity;
    }

    private double getPercentagePeakArea(IChromatogram chromatogram, IPeak peak) {
        double peakAreaPercent = 0.0;
        if (chromatogram != null && peak != null) {
            double chromatogramPeakArea = chromatogram.getPeakIntegratedArea();
            peakAreaPercent = this.getPercentagePeakArea(chromatogramPeakArea, peak.getIntegratedArea());
        }
        return peakAreaPercent;
    }

    private double getPercentagePeakArea(double chromatogramPeakArea, double integratedArea) {
        double peakAreaPercent = 0.0;
        if (chromatogramPeakArea > 0.0) {
            peakAreaPercent = 100.0 / chromatogramPeakArea * integratedArea;
        }
        return peakAreaPercent;
    }

    private float getRetentionIndex(IPeakModel peakModel) {
        float retentionIndex = 0.0f;
        if (peakModel instanceof IPeakModelMSD) {
            IPeakModelMSD peakModelMSD = (IPeakModelMSD)peakModel;
            retentionIndex = peakModelMSD.getPeakMassSpectrum().getRetentionIndex();
        }
        return retentionIndex;
    }
}

