/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.ISampleQuantReader;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.SampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.SampleQuantSubstance;
import org.eclipse.core.runtime.IProgressMonitor;

public class SampleQuantReader_1100
implements ISampleQuantReader {
    @Override
    public ISampleQuantReport read(File file, IProgressMonitor monitor) throws Exception {
        ISampleQuantReport sampleQuantReport = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                monitor.subTask("Import Sample Quant Report");
                sampleQuantReport = this.readFromZipFile(zipFile, monitor);
            }
        }
        return sampleQuantReport;
    }

    private boolean isValidFileFormat(ZipFile zipFile) throws IOException {
        boolean isValid = false;
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "VERSION");
        String version = this.readString(dataInputStream);
        if (version.equals("1.1.0.0")) {
            isValid = true;
        }
        dataInputStream.close();
        return isValid;
    }

    private ISampleQuantReport readFromZipFile(ZipFile zipFile, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "DATA");
        SampleQuantReport sampleQuantReport = new SampleQuantReport();
        sampleQuantReport.setPathChromatogramOriginal(this.readString(dataInputStream));
        sampleQuantReport.setPathChromatogramEdited(this.readString(dataInputStream));
        sampleQuantReport.setName(this.readString(dataInputStream));
        sampleQuantReport.setDataName(this.readString(dataInputStream));
        sampleQuantReport.setDate(this.readString(dataInputStream));
        sampleQuantReport.setOperator(this.readString(dataInputStream));
        sampleQuantReport.setMiscInfo(this.readString(dataInputStream));
        int size = dataInputStream.readInt();
        int i = 0;
        while (i < size) {
            SampleQuantSubstance sampleQuantSubstance = new SampleQuantSubstance();
            sampleQuantSubstance.setId(dataInputStream.readInt());
            sampleQuantSubstance.setCasNumber(this.readString(dataInputStream));
            sampleQuantSubstance.setName(this.readString(dataInputStream));
            sampleQuantSubstance.setMaxScan(dataInputStream.readInt());
            sampleQuantSubstance.setConcentration(dataInputStream.readDouble());
            sampleQuantSubstance.setUnit(this.readString(dataInputStream));
            sampleQuantSubstance.setMinMatchQuality(dataInputStream.readDouble());
            sampleQuantSubstance.setMatchQuality(dataInputStream.readDouble());
            sampleQuantSubstance.setValidated(dataInputStream.readBoolean());
            sampleQuantReport.getSampleQuantSubstances().add(sampleQuantSubstance);
            ++i;
        }
        dataInputStream.close();
        return sampleQuantReport;
    }

    private DataInputStream getDataInputStream(ZipFile zipFile, String entryName) throws IOException {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            String name;
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory() || !(name = zipEntry.getName()).equals(entryName)) continue;
            return new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry)));
        }
        throw new IOException("There could be found no entry given with the name: " + entryName);
    }

    private String readString(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i <= length) {
            builder.append(String.valueOf(dataInputStream.readChar()));
            ++i;
        }
        return builder.toString();
    }
}

