/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.preferences;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.Activator;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.DoubleFieldEditor;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.SpacerFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePageSampleQuant
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public PreferencePageSampleQuant() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Sample Quant Report");
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new FileFieldEditor("samplequantFilterPathTargets", "targets.txt", this.getFieldEditorParent()));
        Button buttonCreateTargets = new Button(this.getFieldEditorParent(), 8);
        buttonCreateTargets.setText("Create demo targets.txt");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        buttonCreateTargets.setLayoutData((Object)gridData);
        buttonCreateTargets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                FileDialog fileDialog = new FileDialog(shell, 8192);
                fileDialog.setText("Demo targets.txt");
                fileDialog.setFilterExtensions(new String[]{"*.txt"});
                fileDialog.setFilterNames(new String[]{"Targets *.txt"});
                fileDialog.setFileName("targets.txt");
                String targetsFile = fileDialog.open();
                if (targetsFile != null) {
                    try {
                        PrintWriter printWriter = new PrintWriter(new FileWriter(new File(targetsFile)));
                        printWriter.println("#NAME\tCAS");
                        printWriter.println("Styrene\t100-42-5");
                        printWriter.println("Benzene\t71-43-2");
                        printWriter.flush();
                        printWriter.close();
                        MessageBox messageBox = new MessageBox(shell, 2);
                        messageBox.setText("Export Demo targets.txt");
                        messageBox.setMessage("Export of demo targets.txt file finished successfully.");
                        messageBox.open();
                    }
                    catch (Exception e1) {
                        MessageBox messageBox = new MessageBox(shell, 8);
                        messageBox.setText("Export Demo targets.txt");
                        messageBox.setMessage("Something has gone wrong whilst exporting the demo targets.txt file.");
                        messageBox.open();
                    }
                }
            }
        });
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new DoubleFieldEditor("samplequantMinMatchQuality", "Min Match Quality", 0.0, 100.0, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("samplequantScanIdentifier", "Scan Identifier:", PreferenceSupplier.getMassSpectrumIdentifier(), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("samplequantSearchCaseSensitive", "Case sensitive search: ", this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }
}

