/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.EvaluationPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IAnalysisSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart2d.ScorePlot;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.preferences.PreferencePage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.preferences.PreferencePageScorePlot;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt.ISelectionListenerPCs;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt.PrincipalComponentUI;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExtendedScorePlot2D
extends Composite {
    private ScorePlot plot;
    private PrincipalComponentUI principalComponentUI;
    private EvaluationPCA evaluationPCA = null;

    public ExtendedScorePlot2D(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setInput(EvaluationPCA evaluationPCA) {
        this.evaluationPCA = evaluationPCA;
        this.updateWidgets();
        this.applySettings();
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(this);
        this.plot = this.createPlot(this);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.principalComponentUI = this.createPrincipalComponentUI(composite);
        this.createSettingsButton(composite);
    }

    private ScorePlot createPlot(Composite parent) {
        ScorePlot plot = new ScorePlot(parent, 2048);
        plot.setLayoutData(new GridData(1808));
        return plot;
    }

    private PrincipalComponentUI createPrincipalComponentUI(Composite parent) {
        PrincipalComponentUI principalComponentUI = new PrincipalComponentUI(parent, 0, 3);
        principalComponentUI.setSelectionListener(new ISelectionListenerPCs(){

            @Override
            public void update(int pcX, int pcY, int pcZ) {
                ExtendedScorePlot2D.this.updatePlot(pcX, pcY);
            }
        });
        return principalComponentUI;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePage()));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new PreferencePageScorePlot()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedScorePlot2D.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private void applySettings() {
        int pcX = this.principalComponentUI.getPCX();
        int pcY = this.principalComponentUI.getPCY();
        this.updatePlot(pcX, pcY);
    }

    private void updateWidgets() {
        if (this.evaluationPCA != null) {
            IAnalysisSettings analysisSettings = this.evaluationPCA.getSamples().getAnalysisSettings();
            this.principalComponentUI.setInput(analysisSettings);
        } else {
            this.principalComponentUI.setInput(null);
        }
    }

    private void updatePlot(int pcX, int pcY) {
        if (this.evaluationPCA != null) {
            this.plot.setInput(this.evaluationPCA, pcX, pcY);
        } else {
            this.plot.setInput(null, pcX, pcY);
        }
    }
}

