/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IExtractionData;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IPreprocessingSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.PcaExtractionScans;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.ScansExtractionSupport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IAnalysisSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.FilterWizardPage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.GroupNamesWizardPage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.IInputWizard;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.PreprocessingWizardPage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.ScanFilesWizardPage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.ScanSettingsWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ScansInputWizard
extends Wizard
implements IInputWizard {
    private ScanSettingsWizardPage scanSettingsWizardPage = new ScanSettingsWizardPage();
    private ScanFilesWizardPage scanFilesWizardPage = new ScanFilesWizardPage();
    private GroupNamesWizardPage groupNamesWizardPage = new GroupNamesWizardPage();
    private PreprocessingWizardPage preprocessingWizardPage = new PreprocessingWizardPage();
    private FilterWizardPage filterWizardPage = new FilterWizardPage();
    private PcaExtractionScans pcaExtractionData;

    public void addPages() {
        this.addPage((IWizardPage)this.scanSettingsWizardPage);
        this.addPage((IWizardPage)this.scanFilesWizardPage);
        this.addPage((IWizardPage)this.groupNamesWizardPage);
        this.addPage((IWizardPage)this.preprocessingWizardPage);
        this.addPage((IWizardPage)this.filterWizardPage);
    }

    @Override
    public IExtractionData getExtractionData() {
        return this.pcaExtractionData;
    }

    @Override
    public List<IDataInputEntry> getDataInputEntries() {
        return this.scanFilesWizardPage.getUniqueDataInputEnties();
    }

    @Override
    public IAnalysisSettings getAnalysisSettings() {
        return this.scanSettingsWizardPage.getAnalysisSettings();
    }

    @Override
    public IPreprocessingSettings getPreprocessingSettings() {
        return this.preprocessingWizardPage.getPreprocessingSettings();
    }

    @Override
    public IFilterSettings getFilterSettings() {
        return this.filterWizardPage.getFilterSettings();
    }

    public boolean performFinish() {
        List<IDataInputEntry> dataInputs = this.getDataInputEntries();
        int retentionTimeWindow = this.scanSettingsWizardPage.getRetentionTimeWindow();
        boolean useDefaultProperties = this.scanSettingsWizardPage.isUseDefaultProperties();
        ScansExtractionSupport.ExtractionType scanAlignment = this.scanSettingsWizardPage.getExtractionType();
        int maximalNumberScans = this.scanSettingsWizardPage.getMaximalNumberScans();
        this.pcaExtractionData = new PcaExtractionScans(retentionTimeWindow, maximalNumberScans, dataInputs, scanAlignment, useDefaultProperties);
        return true;
    }
}

