/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.processor;

import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.result.IDurbinWatsonClassifierResult;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.result.SavitzkyGolayFilterRating;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.settings.ClassifierSettings;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.processor.SavitzkyGolayProcessor;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.settings.ChromatogramFilterSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.core.runtime.IProgressMonitor;

public class DurbinWatsonProcessor {
    private static final Logger logger = Logger.getLogger(DurbinWatsonProcessor.class);

    public void run(IChromatogramSelection<?, ?> chromatogramSelection, ClassifierSettings classifierSettings, IDurbinWatsonClassifierResult durbinWatsonClassifierResult, IProgressMonitor monitor) {
        try {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            TotalScanSignalExtractor signalExtractor = new TotalScanSignalExtractor(chromatogram);
            ITotalScanSignals totalScanSignals = signalExtractor.getTotalScanSignals(chromatogramSelection, false);
            double[] valuesOriginal = this.getScanSignalsAsArray(totalScanSignals);
            this.durbinWatsonMain(valuesOriginal, classifierSettings, durbinWatsonClassifierResult, monitor);
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
    }

    public void durbinWatsonMain(double[] valuesOriginal, ClassifierSettings classifierSettings, IDurbinWatsonClassifierResult durbinWatsonClassifierResult, IProgressMonitor monitor) {
        SavitzkyGolayProcessor savitzkyGolayProcessor = new SavitzkyGolayProcessor();
        int minDerivative = 0;
        int maxDerivative = 5;
        int minOrder = 2;
        int maxOrder = 5;
        int minWidth = 5;
        int maxWidth = 51;
        if (valuesOriginal.length < maxWidth) {
            maxWidth = valuesOriginal.length;
        }
        int derivative = minDerivative;
        while (derivative <= maxDerivative) {
            int order = minOrder;
            while (order <= maxOrder) {
                int width = minWidth;
                while (width <= maxWidth) {
                    if (width % 2 == 1) {
                        ChromatogramFilterSettings filterSettings = new ChromatogramFilterSettings();
                        filterSettings.setDerivative(derivative);
                        filterSettings.setOrder(order);
                        filterSettings.setWidth(width);
                        double[] valuesSmoothed = SavitzkyGolayProcessor.smooth((double[])valuesOriginal, (ChromatogramFilterSettings)filterSettings, (IProgressMonitor)monitor);
                        double rating = this.calculateDurbinWatsonRating(valuesOriginal, valuesSmoothed);
                        durbinWatsonClassifierResult.getSavitzkyGolayFilterRatings().add(new SavitzkyGolayFilterRating(rating, filterSettings));
                    }
                    ++width;
                }
                ++order;
            }
            ++derivative;
        }
    }

    private double calculateDurbinWatsonRating(double[] valuesOriginal, double[] valuesSmoothed) {
        double rating = 0.0;
        if (valuesOriginal.length == valuesSmoothed.length) {
            double denominator = 0.0;
            int i = 0;
            while (i < valuesOriginal.length) {
                denominator += Math.pow(valuesOriginal[i] - valuesSmoothed[i], 2.0);
                ++i;
            }
            if (denominator != 0.0) {
                double nominator = 0.0;
                int i2 = 1;
                while (i2 < valuesOriginal.length) {
                    nominator += Math.pow(valuesOriginal[i2] - valuesSmoothed[i2] - (valuesOriginal[i2 - 1] - valuesSmoothed[i2 - 1]), 2.0);
                    ++i2;
                }
                rating = nominator / denominator;
            }
        }
        return rating;
    }

    private double[] getScanSignalsAsArray(ITotalScanSignals totalScanSignals) {
        int size = totalScanSignals.size();
        double[] ticValues = new double[size];
        int column = 0;
        for (ITotalScanSignal signal : totalScanSignals.getTotalScanSignals()) {
            ticValues[column++] = signal.getTotalSignal();
        }
        return ticValues;
    }
}

